<?php

class PoinzillaEndpoint
{
  private $module;

  public function __construct($module)
  {
    $this->module = $module;
  }


  public function poinzillaUpdateOrderStatus($params)
  {
    PoinzillaLogger::log("Poinzilla sta inziando a sincronizzare l'ordine ", 1);

    try {
      $order = new Order($params['id_order']);
      $customer = new Customer($order->id_customer);

      $setup_mode = PoinzillaHelper::poinzillaSetupMode(true);
      if ($setup_mode && !PoinzillaHelper::poinzillaOrderSyncConditions($this->module, $customer->id, "Poinzilla sincronizzazione ordine skippata. Modalità di setup abilitata ed utente non abiliato ai test." . $customer->id)) {
        return;
      }

      $orderDetails = $order->getProducts();
      PoinzillaLogger::log("Poinzilla ottiene le informazione di Customer ed ordine", 1);

      $lineItems = array();
      foreach ($orderDetails as $product) {
          $productCategories = Product::getProductCategoriesFull($product['product_id']);
          $allCategoryIds = array();

          foreach ($productCategories as $category) {
              $allCategoryIds[] = (string) $category['id_category'];

              // Include parent categories
              $categoryObj = new Category($category['id_category']);
              $parentCategories = $categoryObj->getParentsCategories();
              foreach ($parentCategories as $parentCategory) {
                  $allCategoryIds[] = (string) $parentCategory['id_category'];
              }
          }

          // Remove duplicate categories
          $uniqueCategoryIds = array_unique($allCategoryIds);

          $lineItems[] = array(
              'id' => $product['product_id'],
              'product_id' => $product['id_order_detail'],
              'productCat' => array_values($uniqueCategoryIds),
              'total' => (float) $product['total_price_tax_incl']
          );
      }
      $couponLines = array();
      $cartRules = $order->getCartRules();

      PoinzillaLogger::log("Numero di coupon trovati: " . count($cartRules), 1);
      if (empty($cartRules)) {
        PoinzillaLogger::log("Attenzione: nessun coupon trovato per l'ordine", 2);
      } else {
        foreach ($cartRules as $cartRule) {
          PoinzillaLogger::log("Dati del coupon: " . json_encode($cartRule), 1);

          // Controllo dei valori richiesti
          if (!isset($cartRule['id_cart_rule']) || !isset($cartRule['value'])) {
            PoinzillaLogger::log("Errore: dati del coupon mancanti: " . json_encode($cartRule), 3);
            continue; // Salta questo coupon se mancano dati essenziali
          }

          // Ottengo le info dall'oggetto CartRule
          $cartRuleObj = new CartRule($cartRule['id_cart_rule']);
          if (Validate::isLoadedObject($cartRuleObj)) {
            $discountValue = round((float) $cartRule['value'], 2);
            $couponLines[] = array(
              'id' => (string) $cartRule['id_cart_rule'],
              'code' => (string) $cartRuleObj->code,
              'discount' => $discountValue,
            );
          } else {
            PoinzillaLogger::log("Errore: impossibile caricare CartRule con id: " . $cartRule['id_cart_rule'], 3);
          }
        }
      }

      // Build payload
      $payload = array(
        'id' => (int) $order->id,
        'status' => (string) $order->current_state,
        'customer_id' => (int) $customer->id,
        'total' => number_format((float)$order->total_products_wt, 2, '.', ''),
        'line_items' => $lineItems,
        'coupon_lines' => $couponLines
      );

      $payloadJson = json_encode($payload, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
      PoinzillaLogger::log("Poinzilla ha preparato il payload dell'ordine", 1);
      PoinzillaLogger::log("Poinzilla: " . $payloadJson, 1);

      $response = $this->poinzillaHTTPClient(POINZILLA_API_URL_V1 . "/api/External/Order", $payload);
      $responseCode = $response['code'];
      $responseBody = $response['response'];

      PoinzillaLogger::log("Poinzilla: Risposta HTTP Ricevuta", 1);

      if ($responseCode == 200) {
        PoinzillaLogger::log("Poinzilla ha sincornizzato l'ordine id: " . $order->id, 1);
      } else {
        PoinzillaLogger::log("Errore: Poinzilla payload: " . $payloadJson, 3);
        PoinzillaLogger::log("Errore: Poinzilla non è riuscito a sincronizzazion per l'ordine. Codice risposta: $responseCode, Risposta: $responseBody", 3);
      }
    } catch (Exception $e) {
      PoinzillaLogger::log("Poinzilla Errore: Exception - " . $e->getMessage(), 3);
    }
  }


  public function poinzillaPrepareCustomerData($customer)
  {
    // Check if customer is already sync
    if (PoinzillaHelper::isPoinzillaCustomerSync($customer->id, 1)) {
      PoinzillaLogger::log("Utente già sincronizzato", 1);
      return;
    }

    $userData = array(
      'email' => $customer->email,
      'firstName' => $customer->firstname,
      'lastName' => $customer->lastname,
      'merchantCode' => Configuration::get('POINZILLA_MERCHANT_KEY'),
      'externalId' => (string) $customer->id,
      'birthDate' => null,
      'referralCode' => null,
    );

    PoinzillaLogger::log("Poinzilla ottiene i dati utente", 1);
    return $this->poinzillaSyncCustomer($userData);
  }

  private function poinzillaSyncCustomer($userData)
  {
    PoinzillaLogger::log("Poinzilla inizio sync HTTP", 1);
    $customerId = $this->module->context->customer->id;

    $response = $this->poinzillaHTTPClient(POINZILLA_API_URL_V1 . "/api/External/Consumer", $userData);
    $responseCode = $response['code'];
    $responseBody = $response['response'];

    if ($responseCode == 200) {
        PoinzillaLogger::log("Poinzilla ha sincronizzato l'utente con successo: $customerId.", 1);
        $this->poinzillaUpdateCustumerSyncStatus($customerId, 1);
    } elseif ($responseCode == 400) {
        $responseJson = json_decode($responseBody, true);
        if (isset($responseJson['detail']) && $responseJson['detail'] === "Consumatore già inserito") {
            PoinzillaLogger::log("Poinzilla: Consumatore già inserito, aggiornamento status per l'utente $customerId.", 1);
            $this->poinzillaUpdateCustumerSyncStatus($customerId, 1);
        } else {
            PoinzillaLogger::log("Errore: Poinzilla non è riuscito a sincronizzazion per l'utente $customerId. Codice risposta: $responseCode, Risposta: $responseBody", 3);
        }
    } else {
        PoinzillaLogger::log("Errore: Poinzilla non è riuscito a sincronizzazion per l'utente $customerId. Codice risposta: $responseCode, Risposta: $responseBody", 3);
    }
    
  }

  private function poinzillaHTTPClient($url, $data)
  {
    $curl = curl_init();

    curl_setopt_array(
      $curl,
      array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => array(
          "Content-Type: application/json",
          'X-loyalty-channel-key: ' . Configuration::get('POINZILLA_PUBLIC_KEY')
        ),
      )
    );

    $response = curl_exec($curl);
    $responseCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    $error = curl_error($curl);
    curl_close($curl);

    return array('response' => $response, 'code' => $responseCode, 'error' => $error);
  }

  private function poinzillaUpdateCustumerSyncStatus($customerId, $status)
  {
    $db = Db::getInstance();
    $query = 'SELECT COUNT(*) FROM `' . _DB_PREFIX_ . 'poinzilla_customers` WHERE id_customer = ' . (int) $customerId;
    $exists = $db->getValue($query);

    if ($exists) {
      $updateQuery = 'UPDATE `' . _DB_PREFIX_ . 'poinzilla_customers` SET poinzilla_status = ' . (int) $status . ' WHERE id_customer = ' . (int) $customerId;
      $db->execute($updateQuery);
    } else {
      PoinzillaLogger::log("Modulo Poinzilla ha inserito utente inserito nella tabella: $customerId.", 1);
      $insertQuery = 'INSERT INTO `' . _DB_PREFIX_ . 'poinzilla_customers` (id_customer, poinzilla_status) VALUES (' . (int) $customerId . ', ' . (int) $status . ')';
      $db->execute($insertQuery);
    }

    return true;
  }
}