<?php

require_once _PS_MODULE_DIR_ . 'poinzilla/controllers/admin/PoinzillaAdminController.php';

class AdminExportUsersController extends PoinzillaAdminController
{
    public function __construct()
    {
        parent::__construct($this->module);
        $this->bootstrap = true;
    }

    public function initContent()
    {
        parent::initContent();
        $this->context->smarty->assign(array(
            'form_action' => self::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminExportUsers')
        ));
        $this->setTemplate('export_users.tpl');
    }

    public function postProcess()
    {
        if (Tools::isSubmit('submitExport')) {
            $groupId = (int)Tools::getValue('group_id');
            $points = (int)Tools::getValue('points');

            // Fetch users based on group ID
            $sql = 'SELECT firstname, lastname, email, id_customer as externalID, "" as birthDate, '.$points.' as points
                    FROM '._DB_PREFIX_.'customer
                    WHERE id_default_group = '.$groupId;

            $users = Db::getInstance()->executeS($sql);

            // Generate CSV
            $csv = 'firstName,lastName,email,externalID,birthDate,points'."\n";
            foreach ($users as $user) {
                $csv .= implode(',', $user)."\n";
            }

            // Output CSV
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename=users.csv');
            echo $csv;
            exit;
        }
    }
}
?>