<?php

class PoinzillaAdminController
{
  private $module;

  public function __construct($module)
  {
    $this->module = $module;
  }

  public function getContent()
  {
    $output = null;

    if (Tools::isSubmit('submitPoinzillaModule')) {
      $output = $this->postProcess();
    }

    if (Tools::isSubmit('submitExport')) {
      $output .= $this->exportUsers();
    }

    return $output . $this->renderForm();
  }

  private function postProcess()
  {
    Configuration::updateValue('POINZILLA_MERCHANT_KEY', Tools::getValue('POINZILLA_MERCHANT_KEY'));
    Configuration::updateValue('POINZILLA_PUBLIC_KEY', Tools::getValue('POINZILLA_PUBLIC_KEY'));
    Configuration::updateValue('POINZILLA_PRIVATE_KEY', Tools::getValue('POINZILLA_PRIVATE_KEY'));
    Configuration::updateValue('POINZILLA_SETUP_MODE', Tools::getValue('POINZILLA_SETUP_MODE'));
    Configuration::updateValue('POINZILLA_ALLOWED_CUSTOMERS', Tools::getValue('POINZILLA_ALLOWED_CUSTOMERS'));
    Configuration::updateValue('POINZILLA_ENABLE_LOG', Tools::getValue('POINZILLA_ENABLE_LOG'));

    // Clear module-specific cache
    PoinzillaHelper::poinzillaClearModuleCache();

    return $this->module->displayConfirmation($this->module->l('Impostazioni aggiornate con successo'));
  }

  private function renderForm()
  {
    $inputvar = [
      [
        'col' => 4,
        'type' => 'text',
        'required' => true,
        'desc' => 'Non sai dove trovarlo? <a href="https://account.poinzilla.com/dashboard/apps/api-keys" target="_blank">' . $this->module->l('Clicca qui') . '</a>',
        'name' => 'POINZILLA_MERCHANT_KEY',
        'label' => $this->module->l('Codice merchant'),
      ],
      [
        'col' => 4,
        'required' => true,
        'type' => 'text',
        'desc' => 'Non sai dove trovarlo? <a href="https://account.poinzilla.com/dashboard/apps/api-keys" target="_blank">' . $this->module->l('Clicca qui') . '</a>',
        'name' => 'POINZILLA_PUBLIC_KEY',
        'label' => $this->module->l('Chiave pubblica'),
      ],
      [
        'col' => 4,
        'type' => 'text',
        'required' => true,
        'desc' => 'Non sai dove trovarlo? <a href="https://account.poinzilla.com/dashboard/apps/api-keys" target="_blank">' . $this->module->l('Clicca qui') . '</a>',
        'name' => 'POINZILLA_PRIVATE_KEY',
        'label' => $this->module->l('Chiave privata'),
      ],
      [
        'col' => 4,
        'type' => 'switch',
        'required' => false,
        'desc' => $this->module->l('Attivando questa modalità i tuoi ordini e gli utenti non saranno sicronizzati su Poinzilla. Il widget sarà visibile solo per gli utenti amministratori. Potrai effettuare un test di ordine utilizzando la funzionalità di invio manuale all\'interno della pagina d\'ordine. Verifica che l\'account con cui effettui i test sia censito su Poinzilla.'),
        'name' => 'POINZILLA_SETUP_MODE',
        'label' => $this->module->l('Modalità di setup'),
        'is_bool' => true,
        'values' => [
          [
            'id' => 'setup_mode_on',
            'value' => 1,
            'label' => $this->module->l('Attiva'),
          ],
          [
            'id' => 'setup_mode_off',
            'value' => 0,
            'label' => $this->module->l('Disattiva'),
          ],
        ],
      ],
      [
        'col' => 4,
        'type' => 'textarea',
        'desc' => $this->module->l('Inserisci tutte le email dei clienti separate da una virgola, per consentire di visualizzare il widget a frontend quando la modalità di setup è attiva.'),
        'name' => 'POINZILLA_ALLOWED_CUSTOMERS',
        'label' => $this->module->l('Email consentite'),
      ],
      [
        'col' => 4,
        'type' => 'switch',
        'required' => false,
        'desc' => $this->module->l('Abilita o disabilita il logging'),
        'name' => 'POINZILLA_ENABLE_LOG',
        'label' => $this->module->l('Abilita Log'),
        'is_bool' => true,
        'values' => [
          [
            'id' => 'log_on',
            'value' => 1,
            'label' => $this->module->l('Abilitato'),
          ],
          [
            'id' => 'log_off',
            'value' => 0,
            'label' => $this->module->l('Disabilitato'),
          ],
        ],
      ]
    ];

    $fields_form = array(
      'form' => array(
        'legend' => array(
          'title' => $this->module->l('Impostazioni'),
          'icon' => 'icon-cogs',
        ),
        'input' => $inputvar,
        'submit' => array(
          'title' => $this->module->l('Salva'),
        ),
      ),
    );

    $helper = new HelperForm();
    $helper->show_toolbar = false;
    // $helper->table = $this->module->table;
    $helper->module = $this->module;
    $helper->default_form_language = (int) Configuration::get('PS_LANG_DEFAULT');
    $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;

    $helper->identifier = $this->module->identifier;
    $helper->submit_action = 'submitPoinzillaModule';
    $helper->currentIndex = $this->module->currentIndex;
    $helper->token = Tools::getAdminTokenLite('AdminModules');

    $helper->tpl_vars = array(
      'fields_value' => $this->getConfigFormValues(),
      'languages' => Language::getLanguages(false),
      'id_language' => $this->module->context->language->id,
    );

    return $helper->generateForm(array($fields_form)) . $this->renderExportButton();
  }

  private function getConfigFormValues()
  {
    return array(
      'POINZILLA_MERCHANT_KEY' => Configuration::get('POINZILLA_MERCHANT_KEY', ''),
      'POINZILLA_PUBLIC_KEY' => Configuration::get('POINZILLA_PUBLIC_KEY', ''),
      'POINZILLA_PRIVATE_KEY' => Configuration::get('POINZILLA_PRIVATE_KEY', ''),
      'POINZILLA_SETUP_MODE' => Configuration::get('POINZILLA_SETUP_MODE', 0),
      'POINZILLA_ALLOWED_CUSTOMERS' => Configuration::get('POINZILLA_ALLOWED_CUSTOMERS', ''),
      'POINZILLA_ENABLE_LOG' => Configuration::get('POINZILLA_ENABLE_LOG', 0),
    );
  }

  private function renderExportButton()
  {
    $html = '<div class="panel"><div class="panel-heading">';
    $html .= '<i class="icon-download"></i> ' . $this->module->l('Esporta Utenti') . '</div>';
    $html .= '<div class="panel-body">';
    $html .= '<form action="' . $_SERVER['REQUEST_URI'] . '" method="post" class="form-horizontal">';

    // Selezione del gruppo utenti
    $html .= '<div class="form-group">';
    $html .= '<label class="control-label col-lg-3">' . $this->module->l('Gruppo Utenti') . '</label>';
    $html .= '<div class="col-lg-6">';
    $html .= '<select name="POINZILLA_USER_GROUP" class="form-control">';
    $groups = Group::getGroups((int) Context::getContext()->language->id);
    foreach ($groups as $group) {
      $html .= '<option value="' . $group['id_group'] . '">' . $group['name'] . '</option>';
    }
    $html .= '</select>';
    $html .= '</div></div>';

    // Input per i punti da assegnare
    $html .= '<div class="form-group">';
    $html .= '<label class="control-label col-lg-3">' . $this->module->l('Punti da assegnare') . '</label>';
    $html .= '<div class="col-lg-6">';
    $html .= '<input type="number" name="POINZILLA_EXPORT_POINTS" class="form-control" value="0" />';
    $html .= '</div></div>';

    // Bottone per l'esportazione
    $html .= '<div class="form-group">';
    $html .= '<div class="col-lg-offset-3 col-lg-9">';
    $html .= '<button type="submit" name="submitExport" class="btn btn-primary">' . $this->module->l('Esporta') . '</button>';
    $html .= '</div></div>';

    $html .= '</form>';
    $html .= '</div></div>';

    return $html;
  }

  private function exportUsers()
  {
    $groupId = (int) Tools::getValue('POINZILLA_USER_GROUP');
    $points = (int) Tools::getValue('POINZILLA_EXPORT_POINTS');

    // Fetch users based on group ID
    $sql = 'SELECT firstname, lastname, email, id_customer as externalID, "" as birthDate, ' . $points . ' as points
              FROM ' . _DB_PREFIX_ . 'customer
              WHERE id_default_group = ' . $groupId;

    $users = Db::getInstance()->executeS($sql);

    // Generate CSV
    $csv = 'firstName,lastName,email,externalID,birthDate,points' . "\n";
    foreach ($users as $user) {
      $csv .= implode(',', $user) . "\n";
    }

    // Generate timestamp for the filename
    $timestamp = date('Ymd_His');
    $filename = 'poinzilla-utenti-' . $timestamp . '.csv';

    // Output CSV
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment;filename=' . $filename);
    echo $csv;
    exit;
  }

}

