<?php

class FrontPoinzillaController
{
    private $module;

    public function __construct($module)
    {
        $this->module = $module;
    }

    public function poinzillaWidgetInit()
    {
        $customerId = $this->module->context->customer->id ? $this->module->context->customer->id : 'guest';

        // Loggo i dati dell'utente, mi servirà per debug
        $currentUser = $this->module->context->customer;
        PoinzillaLogger::log('Dati utente corrente: ' . json_encode(array(
            'id' => $customerId,
            'firstname' => $currentUser->firstname ? $currentUser->firstname : 'guest',
            'lastname' => $currentUser->lastname ? $currentUser->lastname : 'guest',
            'email' => $currentUser->email ? $currentUser->email : 'guest'
        )));

        // Controllo se posso mostrare il widget
        if (!PoinzillaHelper::poinzillaSetupModeAndUsersAllow($this->module, "Poinzilla SDK: Non abilitato. Modalità setup attiva e utente corrente non autorizzato all'anteprima. ID Cliente: " . $currentUser->email)) {
            return '';
        }

        // Prendo il codice referral e la vista predefinita dalla sessione
        $referralCode = $this->module->context->cookie->__get('poinzilla_referral_code');
        $defaultView = $this->module->context->cookie->__get('poinzilla_default_view');

        // Pulisco i dati dalla sessione dopo l'uso
        $this->module->context->cookie->__unset('poinzilla_referral_code');
        $this->module->context->cookie->__unset('poinzilla_default_view');

        // Controllo se il cliente è loggato
        $isCustomerLoggedIn = isset($currentUser->id) && $currentUser->id;

        // Genero il digest solo se il cliente è loggato
        $userDigest = '';
        if ($isCustomerLoggedIn) {
            $userDigest = PoinzillaHelper::poinzillaGenerateDigest($currentUser->email);
        }

        // Genero l'HTML direttamente
        return $this->generateHtml($currentUser, $userDigest, $referralCode, $defaultView);
    }
 
    public function poinzillaHandleReferralRedirect()
    {
        $currentUrl = $_SERVER['REQUEST_URI'];
        $baseUrl = $this->module->context->shop->getBaseURL();
        $pattern = '/^\\/referral\\/([a-zA-Z0-9]+)\\/referral$/';

        if (preg_match($pattern, $currentUrl, $matches)) {
            $referralCode = $matches[1];
            $newUrl = $baseUrl . '?referral_code=' . $referralCode . '&default_view=referral-action';

            // Salvo il codice referral e la vista predefinita nella sessione
            $this->module->context->cookie->__set('poinzilla_referral_code', $referralCode);
            $this->module->context->cookie->__set('poinzilla_default_view', 'referral-action');
            
            if (method_exists($this->module->context->cookie, 'write')) {
                $this->module->context->cookie->write();
            }

            Tools::redirect($newUrl);
        }
    }

    public function poinzillaSDKInit()
    {
        // Controllo se posso inizializzare l'SDK
        if (!PoinzillaHelper::poinzillaSetupModeAndUsersAllow($this->module, "Poinzilla SDK: Non abilitato. Modalità setup attiva e utente corrente non autorizzato all'anteprima. ID Cliente: " . $this->module->context->customer->email)) {
            return '';
        }

        $sdkUrl = POINZILLA_SDK_URL_V1 . '?nocache=' . time();
        
        // In PHP 7.2 meglio evitare heredoc con variabili, uso concatenazione
        $script = '<script>' . PHP_EOL;
        $script .= '(function () {' . PHP_EOL;
        $script .= '    var s = document.createElement("script");' . PHP_EOL;
        $script .= '    s.type = "text/javascript";' . PHP_EOL;
        $script .= '    s.async = true;' . PHP_EOL;
        $script .= '    s.defer = true;' . PHP_EOL;
        $script .= '    s.src = "' . $sdkUrl . '";' . PHP_EOL;
        $script .= '    var x = document.getElementsByTagName("script")[0];' . PHP_EOL;
        $script .= '    x.parentNode.insertBefore(s, x);' . PHP_EOL;
        $script .= '})();' . PHP_EOL;
        $script .= '</script>';

        return $script;
    }

    private function generateHtml($currentUser, $userDigest, $referralCode, $defaultView)
    {
        // Genero l'HTML con tutti i dati necessari per il widget
        return '<div class="poinzilla-login-user-info" ' .
               'data-merchant-code="' . htmlspecialchars(Configuration::get('POINZILLA_MERCHANT_KEY')) . '" ' .
               'data-api-key="' . htmlspecialchars(Configuration::get('POINZILLA_PUBLIC_KEY')) . '" ' .
               'data-iframe-site-url="' . htmlspecialchars(POINZILLA_WIDGET_URL_V1) . '" ' .
               'data-api-url="' . htmlspecialchars(POINZILLA_API_URL_V1) . '" ' .
               'data-first-name="' . htmlspecialchars($currentUser->firstname ? $currentUser->firstname : '') . '" ' .
               'data-last-name="' . htmlspecialchars($currentUser->lastname ? $currentUser->lastname : '') . '" ' .
               'data-email="' . htmlspecialchars($currentUser->email ? $currentUser->email : '') . '" ' .
               'data-digest="' . htmlspecialchars($userDigest) . '" ' .
               'data-referral-code="' . htmlspecialchars($referralCode) . '" ' .
               'data-default-view="' . htmlspecialchars($defaultView) . '">' .
               '</div>';
    }
}