<?php

if (!defined('_PS_VERSION_')) {
  exit;
}

// Poinzilla Constants
define('POINZILLA_API_URL_V1', 'https://develop.pre-prod.poinzilla.com/be');
define('POINZILLA_WIDGET_URL_V1', 'https://develop.pre-prod.poinzilla.com/widget');
define('POINZILLA_SDK_URL_V1', "https://develop.pre-prod.poinzilla.com/sdk/sdk.umd.js");

include_once __DIR__ . '/helpers/PoinzillaHelper.php';
include_once __DIR__ . '/classes/PoinzillaLogger.php';

class Poinzilla extends Module
{
  //public $table = 'poinzilla';
  public $identifier = 'id_poinzilla';
  protected $config_form = false;
  public $context;
  public function __construct()
  {
    $this->name = 'poinzilla';
    $this->tab = 'advertising_marketing';
    $this->version = '1.0.3';
    $this->author = 'Zoorate Srl';
    $this->need_instance = 0;
    $this->bootstrap = true;

    parent::__construct();

    $this->displayName = $this->l('Poinzilla');
    $this->description = $this->l('Connettore ufficiale di Poinzilla. Lancia il tuo programma di loyalty personalizzato e incrementa il valore dei tuoi clienti.');

    $this->confirmUninstall = $this->l('Sei sicuro di procedere?');

    $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
  }

  public function install()
  {
    // Verifica la versione attuale del modulo nella configurazione
    $currentVersion = Configuration::get('POINZILLA_VERSION');
    
    // Se la versione attuale è diversa dalla versione del modulo, esegui l'aggiornamento
    if ($currentVersion !== $this->version) {
      $this->upgrade();
    }

    Configuration::updateValue('POINZILLA_MERCHANT_KEY', '');
    Configuration::updateValue('POINZILLA_PUBLIC_KEY', '');
    Configuration::updateValue('POINZILLA_PRIVATE_KEY', '');
    Configuration::updateValue('POINZILLA_SETUP_MODE', 1);
    Configuration::updateValue('POINZILLA_ALLOWED_CUSTOMER', '');
    Configuration::updateValue('POINZILLA_ENABLE_LOG', 0);
    Configuration::updateValue('POINZILLA_VERSION', $this->version);

    require_once _PS_MODULE_DIR_ . 'poinzilla/sql/install.php';

    return parent::install()
      && $this->registerHook('actionOrderStatusPostUpdate')
      && $this->registerHook('displayBackOfficeHeader')
      && $this->registerHook('displayAfterBodyOpeningTag')
      && $this->registerHook('actionFrontControllerInitBefore')
      && $this->registerHook('displayHeader')
      && $this->registerHook('actionAuthentication')
      && $this->registerHook('actionCustomerAccountAdd')
      && $this->registerHook('actionDispatcherBefore');

  }

  public function uninstall()
  {
    Configuration::deleteByName('POINZILLA_MERCHANT_KEY', '');
    Configuration::deleteByName('POINZILLA_PUBLIC_KEY', '');
    Configuration::deleteByName('POINZILLA_PRIVATE_KEY', '');
    Configuration::deleteByName('POINZILLA_SETUP_MODE', '');
    Configuration::deleteByName('POINZILLA_ALLOWED_CUSTOMER', '');
    Configuration::deleteByName('POINZILLA_ENABLE_LOG', '');
    Configuration::deleteByName('POINZILLA_VERSION', '');

    require_once _PS_MODULE_DIR_ . 'poinzilla/sql/uninstall.php';

    return parent::uninstall()
      && $this->registerHook('actionOrderStatusPostUpdate')
      && $this->registerHook('displayAfterBodyOpeningTag')
      && $this->registerHook('displayFooterAfter')
      && $this->registerHook('actionFrontControllerInitBefore')
      && $this->registerHook('displayHeader')
      && $this->registerHook('actionAuthentication')
      && $this->registerHook('actionCustomerAccountAdd')
      && $this->registerHook('actionDispatcherBefore');
  }

  public function upgrade()
  {

    PoinzillaLogger::log('Aggiornamento Modulo Poinzilla');
    PoinzillaHelper::poinzillaClearModuleCache();
    
    return true;
  }

  public function upgradeModule()
  {
    return $this->upgrade();
  }

  public function getContent()
  {
    include_once __DIR__ . '/controllers/admin/AdminPoinzillaController.php';
    $adminController = new PoinzillaAdminController($this);
    return $adminController->getContent();
  }

  public function hookActionOrderStatusPostUpdate($params)
  {
    include_once __DIR__ . '/classes/PoinzillaEndpoint.php';
    $endpoint = new PoinzillaEndpoint($this);
    return $endpoint->poinzillaUpdateOrderStatus($params);
  }

  public function hookDisplayBackOfficeHeader()
  {
      if (Tools::getValue('controller') == 'AdminModules' && Tools::getValue('configure') == $this->name) {
          $this->context->controller->addCSS($this->_path . 'views/css/poinzilla.css');
          $this->context->controller->addJS($this->_path . 'views/js/poinzilla.js');
      }
  }

  public function hookActionAuthentication($params)
  {
    PoinzillaLogger::log("Poinzilla hookActionAuthentication: Login utente effettuato", 1);

    // Check if POINZILLA_SETUP_MODE is active
    if (PoinzillaHelper::poinzillaSetupMode(true)) {
      PoinzillaLogger::log("Poinzilla hookActionAuthentication: Modalità di setup attiva", 2);
      return;
    }

    // Check if customer data are set
    if (!isset($params['customer'])) {
      PoinzillaLogger::log("Poinzilla hookActionAuthentication: Parametri Customer non impostati", 3);
      return;
    }

    // Let's start
    include_once __DIR__ . '/classes/PoinzillaEndpoint.php';
    $endpoint = new PoinzillaEndpoint($this);

    PoinzillaLogger::log("Poinzilla hookActionAuthentication: Inizio a prepare i dati del customer", 1);

    return $endpoint->poinzillaPrepareCustomerData($params['customer']);
  }

  public function hookActionCustomerAccountAdd($params)
  {
    PoinzillaLogger::log("Poinzilla hookActionCustomerAccountAdd: Account creato", 1);

    // Check if POINZILLA_SETUP_MODE is active
    if (PoinzillaHelper::poinzillaSetupMode(true)) {
      PoinzillaLogger::log("Poinzilla hookActionCustomerAccountAdd: Modalità di setup attiva", 2);
      return;
    }

    // Check if customer data are set
    if (!isset($params['newCustomer'])) {
      PoinzillaLogger::log("Poinzilla hookActionCustomerAccountAdd: Parametri Customer non impostati", 3);
      return;
    }

    include_once __DIR__ . '/classes/PoinzillaEndpoint.php';
    $endpoint = new PoinzillaEndpoint($this);

    PoinzillaLogger::log("Poinzilla hookActionCustomerAccountAdd: Inizio a prepare i dati del customer", 1);

    return $endpoint->poinzillaPrepareCustomerData($params['newCustomer']);
  }

  public function hookDisplayAfterBodyOpeningTag()
  {
    include_once __DIR__ . '/controllers/front/FrontPoinzillaController.php';
    $frontController = new FrontPoinzillaController($this);
    return $frontController->poinzillaWidgetInit();
  }

  public function hookActionFrontControllerInitBefore()
  {
    include_once __DIR__ . '/controllers/front/FrontPoinzillaController.php';
    $frontController = new FrontPoinzillaController($this);
    $frontController->poinzillaHandleReferralRedirect();
  }

  public function hookDisplayHeader()
  {
    include_once __DIR__ . '/controllers/front/FrontPoinzillaController.php';
    $controller = new FrontPoinzillaController($this);

    return $controller->poinzillaSDKInit();

  }

}