<?php

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * Classe che gestisce la logica dei form delle cart rule per il campo pz_exclusive_coupon
 */
class PoinzillaCartRuleForm 
{
    /** @var int Valore temporaneo per salvare pz_exclusive_coupon durante la creazione */
    private $_temp_pz_exclusive_coupon_value;

    /**
     * Salva temporaneamente il valore del campo exclusive_coupon durante la creazione
     * della cart rule
     * 
     * @param array $params Contiene l'oggetto CartRule
     * @return void
     */
    public function poinzillaSaveTemporaryExclusiveCouponValue($params) 
    {
        // Verifica se il campo extra per i CartRule è abilitato
        if (!PoinzillaHelper::poinzillaIsExtraCartRulesFieldsEnabled()) {
            return;
        }

        PoinzillaLogger::log("Inizio processo di creazione cart rule");

        if (isset($params['object']) && $params['object'] instanceof CartRule) {
            $raw_input = file_get_contents('php://input');
            PoinzillaLogger::log("XML ricevuto: " . $raw_input);

            try {
                $xml = new SimpleXMLElement($raw_input);
                $pz_exclusive_coupon_value = (int) $xml->cart_rule->pz_exclusive_coupon;
                PoinzillaLogger::log("Valore pz_exclusive_coupon trovato nell'XML: " . $pz_exclusive_coupon_value);

                $this->_temp_pz_exclusive_coupon_value = $pz_exclusive_coupon_value;
                PoinzillaLogger::log("Valore temporaneo salvato: " . $this->_temp_pz_exclusive_coupon_value);
            } catch (Exception $e) {
                PoinzillaLogger::log("Errore durante il parsing dell'XML: " . $e->getMessage());
            }
        }
    }

    /**
     * Salva definitivamente il valore di exclusive_coupon dopo la creazione della cart rule
     * 
     * @param array $params Contiene l'oggetto CartRule con l'ID assegnato
     * @return void
     */
    public function poinzillaPersistExclusiveCouponValue($params) 
    {
        // Verifica se il campo extra per i CartRule è abilitato
        if (!PoinzillaHelper::poinzillaIsExtraCartRulesFieldsEnabled()) {
            return;
        }

        PoinzillaLogger::log("Completamento creazione cart rule");

        if (isset($params['object']) && $params['object'] instanceof CartRule && isset($this->_temp_pz_exclusive_coupon_value)) {
            $id_cart_rule = (int)$params['object']->id;

            if ($id_cart_rule > 0) {
                PoinzillaLogger::log("Aggiornamento cart rule ID: " . $id_cart_rule . " con valore exclusive_coupon: " . $this->_temp_pz_exclusive_coupon_value);
                Db::getInstance()->execute('
                    UPDATE `'._DB_PREFIX_.'cart_rule` 
                    SET `pz_exclusive_coupon` = ' . (int)$this->_temp_pz_exclusive_coupon_value . ' 
                    WHERE `id_cart_rule` = ' . $id_cart_rule
                );
                unset($this->_temp_pz_exclusive_coupon_value);
            } else {
                PoinzillaLogger::log("ID cart rule non valido, aggiornamento non eseguito");
            }
        }
    }

    /**
     * Aggiorna il valore di exclusive_coupon da interfaccia amministrativa
     * 
     * @param array $params Contiene l'oggetto CartRule da aggiornare
     * @return void
     */
    public function poinzillaUpdateExclusiveCouponValue($params) 
    {
        // Verifica se il campo extra per i CartRule è abilitato
        if (!PoinzillaHelper::poinzillaIsExtraCartRulesFieldsEnabled()) {
            return;
        }

        PoinzillaLogger::log("Inizio aggiornamento cart rule da backend");

        if (isset($params['object']) && $params['object'] instanceof CartRule) {
            $pz_exclusive_coupon_value = (int) Tools::getValue('pz_exclusive_coupon', 0);
            PoinzillaLogger::log("Nuovo valore exclusive_coupon da salvare: " . $pz_exclusive_coupon_value);

            Db::getInstance()->execute('
                UPDATE `'._DB_PREFIX_.'cart_rule` 
                SET `pz_exclusive_coupon` = '.(int)$pz_exclusive_coupon_value.' 
                WHERE `id_cart_rule` = '.(int)$params['object']->id
            );
        }
    }
}