<?php

class PoinzillaAdminController
{
  private $module;

  public function __construct($module)
  {
    $this->module = $module;
  }

  public function getContent()
  {
    $output = null;

    if (Tools::isSubmit('submitPoinzillaModule')) {
      $output = $this->postProcess();
    }

    if (Tools::isSubmit('submitPoinzillaUserExport')) {
      $output .= $this->exportUsers();
    }

    return $output . $this->renderForm();
  }

  private function postProcess()
  {
    Configuration::updateValue('POINZILLA_MERCHANT_KEY', Tools::getValue('POINZILLA_MERCHANT_KEY'));
    Configuration::updateValue('POINZILLA_PUBLIC_KEY', Tools::getValue('POINZILLA_PUBLIC_KEY'));
    Configuration::updateValue('POINZILLA_PRIVATE_KEY', Tools::getValue('POINZILLA_PRIVATE_KEY'));
    Configuration::updateValue('POINZILLA_SETUP_MODE', Tools::getValue('POINZILLA_SETUP_MODE'));
    Configuration::updateValue('POINZILLA_ALLOWED_CUSTOMERS', Tools::getValue('POINZILLA_ALLOWED_CUSTOMERS'));
    Configuration::updateValue('POINZILLA_ENABLE_LOG', Tools::getValue('POINZILLA_ENABLE_LOG'));
    Configuration::updateValue('POINZILLA_EXTRA_CART_RULES_FIELDS_ENABLED', Tools::getValue('POINZILLA_EXTRA_CART_RULES_FIELDS_ENABLED'));


    // Clear module-specific cache
    PoinzillaHelper::poinzillaClearModuleCache();

    return $this->module->displayConfirmation($this->module->l('Impostazioni aggiornate con successo'));
  }

  private function renderForm()
  {
    $inputvar = [
      [
        'col' => 4,
        'type' => 'text',
        'required' => true,
        'desc' => 'Non sai dove trovarlo? <a href="https://account.poinzilla.com/dashboard/apps/api-keys" target="_blank">' . $this->module->l('Clicca qui') . '</a>',
        'name' => 'POINZILLA_MERCHANT_KEY',
        'label' => $this->module->l('Codice merchant'),
      ],
      [
        'col' => 4,
        'required' => true,
        'type' => 'text',
        'desc' => 'Non sai dove trovarlo? <a href="https://account.poinzilla.com/dashboard/apps/api-keys" target="_blank">' . $this->module->l('Clicca qui') . '</a>',
        'name' => 'POINZILLA_PUBLIC_KEY',
        'label' => $this->module->l('Chiave pubblica'),
      ],
      [
        'col' => 4,
        'type' => 'text',
        'required' => true,
        'desc' => 'Non sai dove trovarlo? <a href="https://account.poinzilla.com/dashboard/apps/api-keys" target="_blank">' . $this->module->l('Clicca qui') . '</a>',
        'name' => 'POINZILLA_PRIVATE_KEY',
        'label' => $this->module->l('Chiave privata'),
      ],
      [
        'col' => 4,
        'type' => 'switch',
        'required' => false,
        'desc' => $this->module->l('Attivando questa modalità i tuoi ordini e gli utenti non saranno sicronizzati su Poinzilla. Il widget sarà visibile solo per gli utenti amministratori. Potrai effettuare un test di ordine utilizzando la funzionalità di invio manuale all\'interno della pagina d\'ordine. Verifica che l\'account con cui effettui i test sia censito su Poinzilla.'),
        'name' => 'POINZILLA_SETUP_MODE',
        'label' => $this->module->l('Modalità di setup'),
        'is_bool' => true,
        'values' => [
          [
            'id' => 'setup_mode_on',
            'value' => 1,
            'label' => $this->module->l('Attiva'),
          ],
          [
            'id' => 'setup_mode_off',
            'value' => 0,
            'label' => $this->module->l('Disattiva'),
          ],
        ],
      ],
      [
        'col' => 4,
        'type' => 'textarea',
        'desc' => $this->module->l('Inserisci tutte le email dei clienti separate da una virgola, per consentire di visualizzare il widget a frontend quando la modalità di setup è attiva.'),
        'name' => 'POINZILLA_ALLOWED_CUSTOMERS',
        'label' => $this->module->l('Email consentite'),
      ],
      [
        'col' => 4,
        'type' => 'switch',
        'required' => false,
        'desc' => $this->module->l('Abilita o disabilita il logging'),
        'name' => 'POINZILLA_ENABLE_LOG',
        'label' => $this->module->l('Abilita Log'),
        'is_bool' => true,
        'values' => [
          [
            'id' => 'log_on',
            'value' => 1,
            'label' => $this->module->l('Abilitato'),
          ],
          [
            'id' => 'log_off',
            'value' => 0,
            'label' => $this->module->l('Disabilitato'),
          ],
        ],
      ],
      [
        'col' => 4,
        'type' => 'switch',
        'required' => false,
        'desc' => $this->module->l('Questa funzionalità abilita i campi extra di Poinzilla per le regole carrello. Se ci sono problemi di compatibilità con altri moduli, disabilita questa opzione.'),
        'name' => 'POINZILLA_EXTRA_CART_RULES_FIELDS_ENABLED',
        'label' => $this->module->l('Abilita campi extra per regole carrello'),
        'is_bool' => true,
        'values' => [
          [
            'id' => 'extra_cart_fields_on',
            'value' => 1,
            'label' => $this->module->l('Abilitato'),
          ],
          [
            'id' => 'extra_cart_fields_off',
            'value' => 0,
            'label' => $this->module->l('Disabilitato'),
          ],
        ],
      ]
    ];

    $fields_form = array(
      'form' => array(
        'legend' => array(
          'title' => $this->module->l('Impostazioni'),
          'icon' => 'icon-cogs',
        ),
        'input' => $inputvar,
        'submit' => array(
          'title' => $this->module->l('Salva'),
        ),
      ),
    );

    $helper = new HelperForm();
    $helper->show_toolbar = false;
    $helper->module = $this->module;
    $helper->default_form_language = (int) Configuration::get('PS_LANG_DEFAULT');
    $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;

    $helper->identifier = $this->module->identifier;
    $helper->submit_action = 'submitPoinzillaModule';
    $helper->currentIndex = $this->module->currentIndex;
    $helper->token = Tools::getAdminTokenLite('AdminModules');

    $helper->tpl_vars = array(
      'fields_value' => $this->getConfigFormValues(),
      'languages' => Language::getLanguages(false),
      'id_language' => $this->module->context->language->id,
    );

    return $helper->generateForm(array($fields_form)) . $this->renderExportUserForm();
  }

  private function getConfigFormValues()
  {
    return array(
      'POINZILLA_MERCHANT_KEY' => Configuration::get('POINZILLA_MERCHANT_KEY', ''),
      'POINZILLA_PUBLIC_KEY' => Configuration::get('POINZILLA_PUBLIC_KEY', ''),
      'POINZILLA_PRIVATE_KEY' => Configuration::get('POINZILLA_PRIVATE_KEY', ''),
      'POINZILLA_SETUP_MODE' => Configuration::get('POINZILLA_SETUP_MODE', 0),
      'POINZILLA_ALLOWED_CUSTOMERS' => Configuration::get('POINZILLA_ALLOWED_CUSTOMERS', ''),
      'POINZILLA_ENABLE_LOG' => Configuration::get('POINZILLA_ENABLE_LOG', 0),
      'POINZILLA_EXTRA_CART_RULES_FIELDS_ENABLED' => Configuration::get('POINZILLA_EXTRA_CART_RULES_FIELDS_ENABLED', 0),
    );
  }
  /**
   * Renderizza il form per l'esportazione degli utenti
   * 
   * @return string HTML del form
   */
  private function renderExportUserForm()
  {
    $html = '<div class="panel"><div class="panel-heading">';
    $html .= '<i class="icon-download"></i> ' . $this->module->l('Esporta Utenti') . '</div>';
    $html .= '<div class="panel-body">';
    $html .= '<form action="' . $_SERVER['REQUEST_URI'] . '" method="post" class="form-horizontal">';

    // Selezione del gruppo utenti
    $html .= '<div class="form-group">';
    $html .= '<label class="control-label col-lg-3">' . $this->module->l('Gruppo Utenti') . '</label>';
    $html .= '<div class="col-lg-6">';
    $html .= '<select name="POINZILLA_USER_GROUP" class="form-control">';
    // Aggiunta opzione TUTTI
    $html .= '<option value="0">' . $this->module->l('Tutti') . '</option>';
    $groups = Group::getGroups((int) Context::getContext()->language->id);
    foreach ($groups as $group) {
      $html .= '<option value="' . $group['id_group'] . '">' . $group['name'] . '</option>';
    }
    $html .= '</select>';
    $html .= '</div></div>';

    // Input per i punti da assegnare
    $html .= '<div class="form-group">';
    $html .= '<label class="control-label col-lg-3">' . $this->module->l('Punti da assegnare') . '</label>';
    $html .= '<div class="col-lg-6">';
    $html .= '<input type="number" name="POINZILLA_EXPORT_POINTS" class="form-control" value="0" />';
    $html .= '</div></div>';

    // Bottone per l'esportazione
    $html .= '<div class="form-group">';
    $html .= '<div class="col-lg-offset-3 col-lg-9">';
    $html .= '<button type="submit" name="submitPoinzillaUserExport" class="btn btn-primary">' . $this->module->l('Esporta') . '</button>';
    $html .= '</div></div>';

    $html .= '</form>';
    $html .= '</div></div>';

    return $html;
  }

  /**
   * Esegue l'esportazione degli utenti in un file CSV.
   * Il file conterrà: nome, cognome, email, ID esterno, punti, gruppi e cultura (nell'ordine specificato)
   *
   * @return void Termina lo script inviando un file CSV per il download 
   */
  private function exportUsers()
  {
    $groupId = (int) Tools::getValue('POINZILLA_USER_GROUP');
    $points = (int) Tools::getValue('POINZILLA_EXPORT_POINTS');

    $customerRepository = new PoinzillaCustomerRepository();

    // Recupera gli utenti in base al gruppo con i relativi gruppi di appartenenza
    $sql = '
        SELECT 
            c.id_customer,
            c.firstname, 
            c.lastname, 
            c.email, 
            c.id_customer as externalID, 
            COALESCE(c.id_lang, ' . (int)Configuration::get('PS_LANG_DEFAULT') . ') as id_lang,
            ' . $points . ' as points,
            GROUP_CONCAT(cg.id_group) as groups
        FROM ' . _DB_PREFIX_ . 'customer c
        LEFT JOIN ' . _DB_PREFIX_ . 'customer_group cg ON c.id_customer = cg.id_customer';

    // Aggiunge il filtro per gruppo solo se non è selezionato TUTTI (0)
    if ($groupId > 0) {
      $sql .= ' WHERE c.id_default_group = ' . $groupId;
    }

    $sql .= ' GROUP BY c.id_customer';

    $users = Db::getInstance()->executeS($sql);

    // Genera il CSV con l'intestazione (culture come ultima colonna)
    $csv = 'firstName;lastName;email;externalID;points;groups;culture' . "\n";
    
    foreach ($users as $user) {
      // Crea un oggetto Customer completo per ottenere la cultura
      $customer = new Customer($user['id_customer']);
      $customer->id_lang = $user['id_lang']; // Impostiamo manualmente l'id_lang
      
      // Ottiene la cultura per questo utente
      $culture = $customerRepository->poinzillaGetCustomerCultureId($customer);
      
      // Costruisce la riga CSV con culture come ultima colonna
      $csv .= $user['firstname'] . ';' . 
              $user['lastname'] . ';' . 
              $user['email'] . ';' . 
              $user['externalID'] . ';' . 
              $user['points'] . ';' . 
              $user['groups'] . ';' . 
              $culture . "\n";
    }

    // Genera il timestamp per il nome del file
    $timestamp = date('Ymd_His');
    $filename = 'poinzilla-utenti-' . $timestamp . '.csv';

    // Invia l'header HTTP per il download del file CSV
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment;filename=' . $filename);
    echo $csv;
    exit;
  }
}