<?php
/**
 * 2007-2024 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 *
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * Upgrade alla versione 1.1.0
 * - Aggiunge la colonna pz_exclusive_coupon alla tabella cart_rule
 * - Registra le hook necessarie per il funzionamento dei cart rules
 * - Rimuove i file obsoleti dalla versione precedente
 */
function upgrade_module_1_1_1($module)
{
    PoinzillaLogger::log('Esecuzione upgrade alla versione 1.1.1');

    $hooks = [
      'ActionFrontControllerInitBefore',
    ];

    if (!PoinzillaUpgradeHelper::poinzillaRegisterHook($hooks, $module)) {
      return false;
    }

    PoinzillaLogger::log('Upgrade 1.1.1 completato con successo');
    return true;
}