<?php
if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * Classe base per la gestione delle regole carrello (cart rules)
 * Gestisce la struttura dati delle regole carrello, in particolare il flag per i coupon esclusivi
 */
class PoinzillaCartRule extends ObjectModel
{
    /**
     * @var int ID della regola carrello
     */
    public $id_cart_rule;

    /**
     * @var bool Flag che indica se il coupon è esclusivo
     */
    public $pz_exclusive_coupon;

    /**
     * Definizione della struttura del database per PrestaShop
     * 
     * @var array Definizione dei campi e della loro validazione
     */
    public static $definition = array(
        'table' => 'cart_rule',           // Nome della tabella nel database
        'primary' => 'id_cart_rule',      // Chiave primaria
        'fields' => array(
            'id_cart_rule' => array('type' => self::TYPE_INT),
            'pz_exclusive_coupon' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
        ),
    );

    /**
     * Costruttore della classe
     * 
     * @param int|null $id ID della cart rule da caricare (opzionale)
     */
    public function __construct($id = null)
    {
        parent::__construct($id);
    }
}