<?php
class PoinzillaCartRuleValidator
{
    /**
     * Valida l'aggiunta di un nuovo coupon
     * 
     * @param Cart $cart Carrello corrente
     * @param CartRule $new_cart_rule Nuovo coupon da validare
     * @return bool
     * @throws PrestaShopException
     */
    public function validateCartRuleAdd($cart, $new_cart_rule)
    {
        PoinzillaLogger::log("=== INIZIO VALIDAZIONE COUPON ===", 1);
        PoinzillaLogger::log("Coupon ID: " . $new_cart_rule->id, 1);
        
        try {
            // Verifichiamo se il nuovo coupon è esclusivo
            $is_exclusive = $this->isExclusiveCoupon($new_cart_rule->id);
            PoinzillaLogger::log("È un coupon esclusivo?: " . ($is_exclusive ? 'SÌ' : 'NO'), 1);
    
            // Ottieniamo i coupon esistenti direttamente dal database
            $existing_cart_rules = Db::getInstance()->executeS('
                SELECT ccr.*, cr.* 
                FROM `'._DB_PREFIX_.'cart_cart_rule` ccr
                LEFT JOIN `'._DB_PREFIX_.'cart_rule` cr ON ccr.id_cart_rule = cr.id_cart_rule
                WHERE ccr.id_cart = '.(int)$cart->id.'
                AND ccr.id_cart_rule != '.(int)$new_cart_rule->id
            );
            
            $count = count($existing_cart_rules);
            PoinzillaLogger::log("Trovati " . $count . " altri coupon nel carrello", 1);
            
            if (empty($existing_cart_rules)) {
                PoinzillaLogger::log("Nessun altro coupon nel carrello - Validazione OK", 1);
                return true;
            }
            
            // Se ci sono altri coupon esistenti, facciamo le verifiche
            if ($is_exclusive) {
                PoinzillaLogger::log("Errore: tentativo di aggiungere coupon esclusivo con altri coupon presenti", 3);
                throw new PrestaShopException('Questo coupon è esclusivo e non può essere combinato con altri coupon.');
            }
            
            // Controlliamo se esiste già un coupon esclusivo
            foreach ($existing_cart_rules as $rule) {
                if ($this->isExclusiveCoupon($rule['id_cart_rule'])) {
                    PoinzillaLogger::log("Errore: tentativo di aggiungere coupon quando è già presente un coupon esclusivo", 3);
                    throw new PrestaShopException('Non è possibile aggiungere questo coupon perché è già presente un coupon esclusivo nel carrello.');
                }
            }
            
            PoinzillaLogger::log("=== VALIDAZIONE COMPLETATA CON SUCCESSO ===", 1);
            return true;
            
        } catch (PrestaShopException $e) {
            PoinzillaLogger::log("=== ERRORE VALIDAZIONE ===", 3);
            throw $e;
        }
    }

    /**
     * Verifica se un coupon è esclusivo
     * 
     * @param int $cart_rule_id ID del coupon
     * @return bool
     */
    private function isExclusiveCoupon($cart_rule_id)
    {
        return (bool)Db::getInstance()->getValue('
            SELECT pz_exclusive_coupon 
            FROM `'._DB_PREFIX_.'cart_rule` 
            WHERE `id_cart_rule` = '.(int)$cart_rule_id
        );
    }
}