<?php

class FrontPoinzillaController
{
  private $module;

  public function __construct($module)
  {
    $this->module = $module;
  }

  public function poinzillaWidgetInit()
  {

    if (!PoinzillaHelper::poinzillaSetupModeAndUsersAllow($this->module, "Poinzilla SDK: Non stanziato. Setup mode abilitata ed utente corrente non abilitato alla preview. Id customer: " . $this->module->context->customer->email)) {
      return '';
    }

    // Get referral code and default view from session
    $referralCode = $this->module->context->cookie->__get('poinzilla_referral_code');
    $defaultView = $this->module->context->cookie->__get('poinzilla_default_view');

    // Clear referral code and default view from session after use
    $this->module->context->cookie->__unset('poinzilla_referral_code');
    $this->module->context->cookie->__unset('poinzilla_default_view');

    // Check if customer is logged in
    $isCustomerLoggedIn = isset($this->module->context->customer->id) && $this->module->context->customer->id;

    // Generate digest only if the customer is logged in
    $userDigest = '';
    if ($isCustomerLoggedIn) {
      $userDigest = PoinzillaHelper::poinzillaGenerateDigest($this->module->context->customer->email);
    }

    $templateVars = array(
      'merchantCode' => Configuration::get('POINZILLA_MERCHANT_KEY'),
      'publicKey' => Configuration::get('POINZILLA_PUBLIC_KEY'),
      'api_url' => POINZILLA_API_URL_V1,
      'widget_url' => POINZILLA_WIDGET_URL_V1,
      'user_first_name' => $this->module->context->customer->firstname,
      'user_last_name' => $this->module->context->customer->lastname,
      'user_email' => $this->module->context->customer->email,
      'user_digest' => $userDigest,
      'referral_code' => $referralCode ?: '',
      'default_view' => $defaultView ?: '',
    );

    $this->module->context->smarty->assign($templateVars);
    $output = $this->module->display($this->module->name, 'views/templates/hook/frontend.tpl');

    return $output;
  }

  public function poinzillaHandleReferralRedirect()
  {
    $currentUrl = $_SERVER['REQUEST_URI'];
    $baseUrl = $this->module->context->shop->getBaseURL();
    $pattern = '/^\/referral\/([a-zA-Z0-9]+)\/referral$/';

    if (preg_match($pattern, $currentUrl, $matches)) {
      $referralCode = $matches[1];
      $newUrl = $baseUrl . '?referral_code=' . $referralCode . '&default_view=referral-action';

      // Store referral code and default view in session
      $this->module->context->cookie->__set('poinzilla_referral_code', $referralCode);
      $this->module->context->cookie->__set('poinzilla_default_view', 'referral-action');

      Tools::redirect($newUrl);
    }
  }
  public function poinzillaSDKInit()
  {

    if (!PoinzillaHelper::poinzillaSetupModeAndUsersAllow($this->module, "Poinzilla SDK: Non stanziato. Setup mode abilitata ed utente corrente non abilitato alla preview. Id customer: " . $this->module->context->customer->email)) {
      return '';
    }

    $sdkUrl = POINZILLA_SDK_URL_V1 . '?ver=1.0.0';  // Append version

    $script = <<<EOD
      <script>
          (function () {
              var s = document.createElement('script');
              s.type = 'text/javascript';
              s.async = true;
              s.defer = true;
              s.src = '$sdkUrl';
              var x = document.getElementsByTagName('script')[0];
              x.parentNode.insertBefore(s, x);
          })();
      </script>
      EOD;

    return $script;


  }
}
