<?php

class PoinzillaCartRuleControllerModuleFrontController extends ModuleFrontController
{
    public $module;

    public function __construct($module)
    {
        $this->module = $module;
    }

    /**
     * Metodo per aggiungere un CartRule al carrello
     *
     * @param Cart $cart
     * @param string $couponCode
     * @throws PrestaShopException
     */
    public function poinzillaAddCartRuleToCart($cart, $couponCode)
    {
        // Istanzia il gestore e tenta di aggiungere il coupon al carrello
        $handler = new PoinzillaCartRuleHandler();
        $handler->poinzillaAddCartRuleToCart($cart, $couponCode);
    }

    public function initContent()
    {
        parent::initContent();

        // Recupera l'azione richiesta e il codice del coupon dalla richiesta
        $action = Tools::getValue('action');
        $couponCode = Tools::getValue('coupon_code');
        $cart = $this->context->cart;

        try {
            if ($action === 'add') {
                // Tentiamo di aggiungere e validare il coupon
                $this->poinzillaAddCartRuleToCart($cart, $couponCode);

            } elseif ($action === 'remove') {
                // Gestisce la rimozione manuale senza effettuare validazioni
                $cartRule = PoinzillaCartRuleHelper::getCartRuleByCode($couponCode);
                if ($cartRule) {
                    $handler = new PoinzillaCartRuleHandler();
                    $handler->poinzillaRemoveCartRuleFromCart($cart, $cartRule);
                } else {
                    throw new PrestaShopException('Coupon non trovato');
                }
            } else {
                throw new PrestaShopException('Azione non valida');
            }
        } catch (PrestaShopException $e) {
            // Ritorniamo la risposta con il messaggio di errore in caso di eccezione
            $response = [
                'success' => false,
                'message' => $e->getMessage()
            ];
            header('Content-Type: application/json');
            die(Tools::jsonEncode($response));
        }
    }
}
