<?php
if (!defined('_PS_VERSION_')) {
  exit;
}

/**
 * Controller per la gestione dei referral di Poinzilla
 * Si occupa del reindirizzamento e della gestione dei codici referral
 */
class PoinzillaReferralController
{
  /** @var Module Istanza del modulo Poinzilla */
  private $module;

  /**
   * Costruttore
   * 
   * @param Module $module Istanza del modulo
   */
  public function __construct($module)
  {
    $this->module = $module;
  }

  /**
   * Gestisce il redirect dei referral
   * Intercetta gli URL di referral, salva i dati in sessione e reindirizza alla pagina corretta
   * 
   * Pattern URL supportato: /referral/{codice}/referral
   */
  public function poinzillaHandleReferralRedirect()
  {
    $currentUrl = $_SERVER['REQUEST_URI'];
    $baseUrl = $this->module->context->shop->getBaseURL();
    $pattern = '/referral\/([a-zA-Z0-9]+)\/referral$/';
    
    if (preg_match($pattern, $currentUrl, $matches)) {
      $referralCode = $matches[1];
      $newUrl = $baseUrl . '?referral_code=' . $referralCode . '&default_view=referral-action';

      // Salva i dati referral in sessione
      $this->module->context->cookie->__set('poinzilla_referral_code', $referralCode);
      $this->module->context->cookie->__set('poinzilla_default_view', 'referral-action');

      Tools::redirect($newUrl);
    }
  }
}