<?php

class PoinzillaCartRuleHandler
{
    /**
     * Aggiunge un CartRule al carrello dopo averlo validato.
     *
     * @param Cart $cart Il carrello a cui aggiungere il CartRule.
     * @param string $couponCode Il codice del coupon da aggiungere.
     * @throws PrestaShopException Se la validazione fallisce.
     */
    public function poinzillaAddCartRuleToCart($cart, $couponCode)
    {
        // Recupera il CartRule in base al codice coupon fornito
        $cartRule = PoinzillaCartRuleHelper::getCartRuleByCode($couponCode);
        if (!$cartRule) {
            throw new PrestaShopException('Coupon non valido');
        }

        // Creiamo un'istanza del validatore per verificare se il coupon può essere applicato
        $validator = new PoinzillaCartRuleValidator();

        try {
            // Eseguiamo la validazione del coupon
            $validator->validateCartRuleAdd($cart, $cartRule);

            // Aggiungiamo il CartRule solo se la validazione passa
            $cart->addCartRule($cartRule->id);

        } catch (PrestaShopException $e) {
            // Rimuovi il CartRule dal carrello in caso di errore nella validazione
            $this->poinzillaRemoveCartRuleFromCart($cart, $cartRule);

            // Rilancia l'eccezione per gestirla a livello superiore
            throw $e;
        }
    }

    /**
     * Rimuove un CartRule dal carrello.
     *
     * @param Cart $cart Il carrello da cui rimuovere il CartRule.
     * @param CartRule $cartRule Il CartRule da rimuovere.
     * @return bool True se rimosso con successo, false altrimenti.
     */
    public function poinzillaRemoveCartRuleFromCart($cart, $cartRule)
    {
        // Chiamiamo l'helper per rimuovere il CartRule specificato dal carrello
        return PoinzillaCartRuleHelper::removeCartRule($cart, $cartRule);
    }
}
