<?php
/**
* 2007-2020 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2020 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/
$sql = array();

$sql[] = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'poinzilla_customers` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `id_customer` int(11),
    `poinzilla_status` tinyint(1) NOT NULL,
    PRIMARY KEY  (`id`)
)';

foreach ($sql as $query) {
    if (Db::getInstance()->execute($query) == false) {
        return false;
    }
}

// Verifica esistenza colonna pz_exclusive_coupon
$columnExists = false;
try {
    $result = Db::getInstance()->executeS('SHOW COLUMNS FROM `' . _DB_PREFIX_ . 'cart_rule` LIKE "pz_exclusive_coupon"');
    $columnExists = !empty($result);
} catch (Exception $e) {
    $columnExists = false;
}

if (!$columnExists) {
    $alterQuery = 'ALTER TABLE `' . _DB_PREFIX_ . 'cart_rule` ADD COLUMN `pz_exclusive_coupon` TINYINT(1) NOT NULL DEFAULT 0';
    if (Db::getInstance()->execute($alterQuery) == false) {
        return false;
    }
}