<?php
/**
 * 2007-2024 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 *
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * Upgrade alla versione 1.1.0
 * - Aggiunge la colonna pz_exclusive_coupon alla tabella cart_rule
 * - Registra le hook necessarie per il funzionamento dei cart rules
 * - Rimuove i file obsoleti dalla versione precedente
 */
function upgrade_module_1_1_0($module)
{
    PoinzillaLogger::log('Esecuzione upgrade alla versione 1.1.0');

    if (!PoinzillaUpgradeHelper::poinzillaCreateColumn('cart_rule', 'pz_exclusive_coupon', 'TINYINT(1) NOT NULL DEFAULT 0')) {
        return false;
    }

    $obsoleteHooks = [
      'actionObjectCartRuleAddBefore',
      'actionAjaxDieBefore'
    ];

    if (!PoinzillaUpgradeHelper::poinzillaUnregisterHooks($module, $obsoleteHooks)) {
      return false;
    }

    $hooks = [
      'actionObjectCartRuleAddBefore',
      'actionObjectCartRuleAddAfter',
      'actionObjectCartRuleUpdateBefore',
      'actionCartSave',
      'actionAjaxDieBefore'
    ];

    if (!PoinzillaUpgradeHelper::poinzillaRegisterHook($hooks, $module)) {
        return false;
    }

    if (!PoinzillaUpgradeHelper::poinzillaAddConfiguration('POINZILLA_EXTRA_CART_RULES_FIELDS_ENABLED', false)) {
      return false;
    }

    $obsoleteFiles = [
      'classes/PoinzillaEndpoint.php',
      'controllers/admin/AdminPoinzillaController.php',
      'controllers/front/FrontPoinzillaController.php',
      'controllers/admin/AdminExportUsersController.php',
      'view/css/poinzilla-admin.css',
      'view/js/poinzilla-admin.js'
    ];

    PoinzillaUpgradeHelper::poinzillaRemoveObsoleteFiles($obsoleteFiles);

    PoinzillaLogger::log('Upgrade 1.1.0 completato con successo');
    return true;
}