<?php
defined('ABSPATH') or die('Access denied!');

class Poinzilla_User_Export
{
  public function __construct() {
    add_action('admin_post_export_users', array($this, 'handle_export_users'));
  }

  public function handle_export_users() {
    if (!current_user_can('export')) {
      wp_die('You do not have sufficient permissions to access this page.');
    }

    $selected_roles = isset($_POST['user_roles']) ? $_POST['user_roles'] : [];
    $additional_points = isset($_POST['additional_points']) && is_numeric($_POST['additional_points']) ? (int)$_POST['additional_points'] : 0;
  

    ob_end_clean();
    nocache_headers(); 
    $filename = 'poinzilla_utenti_' . date('Y-m-d_H-i-s') . '.csv';
    header("Content-Type: text/csv");
    header("Content-Disposition: attachment; filename=\"$filename\"");

    $output = fopen("php://output", "w");
    fputcsv($output, array('firstName', 'lastName', 'email', 'externalId', 'birthDate', 'points'));

    $args = array(
      'role__in' => $selected_roles,
      'fields' => 'all_with_meta'
    );
    $users = get_users($args);
    foreach ($users as $user) {
      $firstName = $user->first_name ?: 'default';
      $lastName = $user->last_name ?: 'default';
      $points = $additional_points;  // Apply the optional points value here
      fputcsv($output, array($firstName, $lastName, $user->user_email, $user->ID, '', $points));
    }
    fclose($output);
    exit;
  }
}

