<?php

/**
 * Provide a public-facing view for the plugin
 *
 * This file is used to markup the public-facing aspects of the plugin.
 *
 * @link       https://www.zoorate.com
 * @since      1.0.0
 *
 * @package    Poinzilla
 * @subpackage Poinzilla/public/partials
 */
?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->

<script>
  (function () {
    // Poinzilla = window.Poinzilla || (window.Poinzilla = []);
    var s = document.createElement('script');
    s.type = 'text/javascript';
    s.async = true;
    s.defer = true;
    s.src = '<?php echo POINZILLA_SDK_URL_V1; ?>?ver=<?php echo POINZILLA_VERSION ?>';
    var x = document.getElementsByTagName('script')[0];
    x.parentNode.insertBefore(s, x);
  })();

  function callBackFunction(iframe, button) {

  }
</script>
<?php
if (is_user_logged_in()):
  $user_id = get_current_user_id();
  $is_sync_with_poinzilla = get_user_meta($user_id, 'is_sync_with_poinzilla', true);
  if (!$is_sync_with_poinzilla) {
    $this->poinzilla_user_register($user_id);
  }
endif;
?>
<div class="poinzilla-login-user-info" data-merchant-code="<?php echo get_option('poinzilla_merchant_code'); ?>"
  data-merchant-email="<?php echo get_option('poinzilla_merchant_email'); ?>"
  data-api-key="<?php echo get_option('poinzilla_api_key'); ?>"
  data-iframe-site-url="<?php echo POINZILLA_WIDGET_URL_V1; ?>" data-api-url="<?php echo POINZILLA_API_URL_V1; ?>" <?php if (is_user_logged_in()):
          $poinzilla_user_data = wp_get_current_user();
          $digest = $this->poinzilla_generate_digest($poinzilla_user_data->user_email); ?>
    data-first-name="<?php echo get_user_meta($poinzilla_user_data->ID, 'first_name', true); ?>"
    data-last-name="<?php echo get_user_meta($poinzilla_user_data->ID, 'last_name', true); ?>"
    data-email="<?php echo $poinzilla_user_data->user_email; ?>" <?php endif; ?> data-digest="<?php echo $digest; ?>"
  <?php if (isset($_GET['referral_code'])) {
    echo "data-referral-code='" . $_GET['referral_code'] . "'";
  } ?> <?php if (isset($_GET['default_view'])) {
      echo "data-default-view='" . $_GET['default_view'] . "'";
    } ?>>
</div>