<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://www.zoorate.com
 * @since      1.0.0
 *
 * @package    Poinzilla
 * @subpackage Poinzilla/admin/partials
 */
?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<?php
if (isset($_POST['poinzilla_submit_setting'])) {
  update_option('poinzilla_merchant_code', sanitize_text_field($_POST['poinzilla_merchant_code']));
  update_option('poinzilla_merchant_email', sanitize_text_field($_POST['poinzilla_merchant_email']));
  update_option('poinzilla_api_key', sanitize_text_field($_POST['poinzilla_api_key']));
  update_option('poinzilla_api_secret', sanitize_text_field($_POST['poinzilla_api_secret']));
  update_option('poinzilla_setup_mode', sanitize_text_field($_POST['poinzilla_setup_mode']));
  update_option('poinzilla_enable_log', sanitize_text_field($_POST['poinzilla_enable_log']));
}
?>
<div class="poinzilla-menu-page">
  <div class="poinzilla-heading">
    <div class="poinzilla-heading-logo">
      <img src="<?php echo POINZILLA_PLUGIN_URL . 'admin/images/logo-poinzilla.svg'; ?>">
    </div>
    <div class="poinzilla-heading-actions">
      <div class="poinzilla-heading-navigation">
        <nav>
          <ul>
            <li><a target="_blank" href="https://www.poinzilla.com/materiale/">📚 Conoscienze di base</a></li>
            <li><a target="_blank" href="https://www.poinzilla.com/come_iniziare/">❔ Faq</a></li>
          </ul>
        </nav>
      </div>
      <div class="poinzilla-merchant-login">
        <a target="_blank" href="https://account.poinzilla.com"><button class="btn-ui-outline-poinzilla">Merchant
            dashboard</button></a>
      </div>
    </div>
  </div>
  <div class="poinzilla-content">
    <form class="poinzilla-form" method="post">
      <div class="poinzilla-content-actions">
        <div class="poinzilla-content-actions-navigation">
          <h1><?php _e('Configurazione account', 'POINZILLA_TEXT_DOMAIN'); ?></h1>
        </div>
        <div class="poinzilla-content-actions-save">
          <div class="poinzilla-submit-button">
            <input type="submit" class="btn-ui-poinzilla" name="poinzilla_submit_setting"
              value="<?php _e('Salva impostazioni', POINZILLA_TEXT_DOMAIN); ?>">
          </div>
        </div>
      </div>
      <div class="poinzilla-form-row">
        <div class="poinzilla-form-label">
          <p class="poinzilla-form-label-title"><?php _e('Codice merchant', POINZILLA_TEXT_DOMAIN); ?></label>
        </div>
        <div class="poinzilla-form-input">
          <input type="text" class="input-ui-poinzilla" name="poinzilla_merchant_code"
            value="<?php echo get_option('poinzilla_merchant_code'); ?>">
        </div>
      </div>
      <div class="poinzilla-form-row">
        <div class="poinzilla-form-label">
          <p class="poinzilla-form-label-title"><?php _e('Chiave pubblica', POINZILLA_TEXT_DOMAIN); ?></p>
          <p class="poinzilla-form-label-info"><?php _e('Non sai dove trovarla? Clicca qui', POINZILLA_TEXT_DOMAIN); ?>
          </p>
        </div>
        <div class="poinzilla-form-input">
          <input type="text" class="input-ui-poinzilla" name="poinzilla_api_key"
            value="<?php echo get_option('poinzilla_api_key'); ?>">
        </div>
      </div>
      <div class="poinzilla-form-row">
        <div class="poinzilla-form-label">
          <p class="poinzilla-form-label-title"><?php _e('Chiave privata', POINZILLA_TEXT_DOMAIN); ?></p>
          <p class="poinzilla-form-label-info"><?php _e('Non sai dove trovarla? Clicca qui', POINZILLA_TEXT_DOMAIN); ?>
          </p>
        </div>
        <div class="poinzilla-form-input">
          <input type="text" class="input-ui-poinzilla" name="poinzilla_api_secret"
            value="<?php echo get_option('poinzilla_api_secret'); ?>">
        </div>
      </div>
      <div class="poinzilla-form-row">
        <div class="poinzilla-form-label">
          <p class="poinzilla-form-label-title"><?php _e('Modalità di setup', POINZILLA_TEXT_DOMAIN); ?></label>
          <p class="poinzilla-form-label-info">
            <?php _e('Attivando questa modalità i tuoi ordini e gli utenti non saranno sicronizzati su Poinzilla. Il widget sarà visible solo per gli utenti amministratori. Potrai effettuare un test di ordine utilizzando la funzionalità di invio manuale all\'interno della pagina d\'ordine. Verifica che l\'account con cui effettui i test sia censito su Poinzilla.', POINZILLA_TEXT_DOMAIN); ?>
          </p>
        </div>

        <div class="poinzilla-form-input">
          <label class="switch">
            <input type="checkbox" value="1" class="input-ui-poinzilla" name="poinzilla_setup_mode" <?php echo checked(get_option('poinzilla_setup_mode'), 1); ?>>
            <span class="slider round"></span>
          </label>
        </div>
      </div>
      <div class="poinzilla-form-row">
        <div class="poinzilla-form-label">
          <p class="poinzilla-form-label-title"><?php _e('Abilita log', POINZILLA_TEXT_DOMAIN); ?></label>
          <p class="poinzilla-form-label-info">
            <?php _e('Abilita questa opzione per salvare i log.', POINZILLA_TEXT_DOMAIN); ?>
          </p>
        </div>

        <div class="poinzilla-form-input">
          <label class="switch">
            <input type="checkbox" value="1" class="input-ui-poinzilla" name="poinzilla_enable_log" <?php echo checked(get_option('poinzilla_enable_log'), 1); ?>>
            <span class="slider round"></span>
          </label>
        </div>
      </div>
    </form>
  </div>
</div>