<div class="poinzilla-menu-page">
  <div class="poinzilla-heading">
    <div class="poinzilla-heading-logo">
      <img src="<?php echo POINZILLA_PLUGIN_URL . 'admin/images/logo-poinzilla.svg'; ?>">
    </div>
    <div class="poinzilla-heading-actions">
      <div class="poinzilla-heading-navigation">
        <nav>
          <ul>
            <li><a target="_blank" href="https://www.poinzilla.com/materiale/">📚 Conoscienze di base</a></li>
            <li><a target="_blank" href="https://www.poinzilla.com/come_iniziare/">❔ Faq</a></li>
          </ul>
        </nav>
      </div>
      <div class="poinzilla-merchant-login">
        <a target="_blank" href="https://account.poinzilla.com/"><button
            class="btn-ui-outline-poinzilla">Merchant dashboard</button></a>
      </div>
    </div>
  </div>
  <div class="poinzilla-content">

    <form class="poinzilla-form" method="post" action="<?php echo admin_url('admin-post.php'); ?>">
      <div class="poinzilla-content-actions">
        <div class="poinzilla-content-actions-navigation">
          <h1><?php _e('Esporta utenti', 'POINZILLA_TEXT_DOMAIN'); ?></h1>
          <p><a target="_blank" href="https://account.poinzilla.com/dashboard/utenti/importatore">Clicca qui</a> per accedere al tuo account Poinzilla ed importare il file appena scaricato. <br>Puoi filtrare l'esportazione selezionando solo i ruoli desiderati:</p>
        </div>
        <div class="poinzilla-content-actions-save">
          <div class="poinzilla-submit-button">
            <input type="hidden" name="action" value="export_users">
            <input type="submit" class="btn-ui-poinzilla" name="export_users"
              value="<?php _e('Esporta CSV', POINZILLA_TEXT_DOMAIN); ?>">
          </div>
        </div>
      </div>
      <div class="poinzilla-form-row">
        <div class="poinzilla-form-label">
          <p class="poinzilla-form-label-title"><?php _e('Punti da assegnare (Opzionale)', POINZILLA_TEXT_DOMAIN); ?></p>
          <p class="poinzilla-form-label-info">
            <?php _e('Se desideri puoi assegnare dei punti a tutti gli utenti esportati. Se vuoi premiare specifici ruoli utenti esporta singoli file cambiando questo valore.', POINZILLA_TEXT_DOMAIN); ?>
          </p>
        </div>
        <div class="poinzilla-form-input">
          <input  type="number" min="0" id="additional_points" name="additional_points"  class="input-ui-poinzilla" name="poinzilla_merchant_code">
        </div>
      </div>
      <?php 
      $roles = wp_roles()->roles;
      foreach ($roles as $key => $value) {
        echo '<div class="poinzilla-form-row"><div class="poinzilla-form-label"><p class="poinzilla-form-label-title">'. esc_html($value['name']) . '</p></div><div class="poinzilla-form-input"><label class="switch"><input class="input-ui-poinzilla"  type="checkbox" name="user_roles[]" value="' . esc_attr($key) . '" checked><span class="slider round"></span></label></div></div>';
      }
      ?>


    </form>


  </div>
</div>