<?php
defined('ABSPATH') or exit;

/**
 * Fired during plugin display Logs
 *
 * @link       https://www.zoorate.com
 * @since      1.0.0
 *
 * @package    Poinzilla
 * @subpackage Poinzilla/includes
 */

/**
 * Fired during plugin display Logs.
 *
 * This class defines all code necessary to run during the plugin's display Logs.
 *
 * @since      1.0.0
 * @package    Poinzilla
 * @subpackage Poinzilla/includes
 * @author     Zoorate srl <info@zoorate.com>
 */
class Poinzilla_Logger {
    /**
     * The logger instance
     */
    private $logger;

    /**
     * Initialize the logger with appropriate fallbacks
     */
    public function __construct() {
        // Check if WooCommerce is active and the WC_Logger class exists
        if (class_exists('WC_Logger')) {
            $this->logger = new WC_Logger();
        } else {
            // Fallback to basic logging if WooCommerce isn't available
            $this->logger = null;
        }
    }

    /**
     * Log debug messages
     */
    public function debug($message, $context = array()) {
        if ($this->logger) {
            // Use WooCommerce logger if available
            $this->logger->debug($message, $context);
        } else {
            // Fallback to WordPress error logging
            if (WP_DEBUG && WP_DEBUG_LOG) {
                $formatted_context = !empty($context) ? ' | Context: ' . json_encode($context) : '';
                error_log('[Poinzilla Debug] ' . $message . $formatted_context);
            }
        }
    }

    /**
     * Log error messages
     */
    public function error($message, $context = array()) {
        if ($this->logger) {
            // Use WooCommerce logger if available
            $this->logger->error($message, $context);
        } else {
            // Fallback to WordPress error logging
            $formatted_context = !empty($context) ? ' | Context: ' . json_encode($context) : '';
            error_log('[Poinzilla Error] ' . $message . $formatted_context);
        }
    }

    /**
     * Log info messages
     */
    public function info($message, $context = array()) {
        if ($this->logger) {
            // Use WooCommerce logger if available
            $this->logger->info($message, $context);
        } else {
            // Fallback to WordPress error logging
            if (WP_DEBUG && WP_DEBUG_LOG) {
                $formatted_context = !empty($context) ? ' | Context: ' . json_encode($context) : '';
                error_log('[Poinzilla Info] ' . $message . $formatted_context);
            }
        }
    }
}
