<?php

/**
 * WooCommerce API Webhooks class
 *
 * Handles requests to the /webhooks endpoint
 *
 * @author   WooThemes
 * @category API
 * @package  WooCommerce\RestApi
 * @since    2.2
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

class WC_API_Poinzilla extends WC_REST_Orders_Controller
{
	/**
	 * Endpoint namespace.
	 *
	 * @var string
	 */
	//protected $namespace = 'wc/v3';

	/**
	 * Route base.
	 *
	 * @var string
	 */
	//protected $rest_base = 'poinzilla';

	public function __construct()
	{
		//	add_action('rest_api_init', array($this, 'register_routes'), 10);
	}


	/**
	 * Register the routes for this class
	 *
	 * @since 2.2
	 * @param array $routes
	 * @return array
	 */
	public function register_routes()
	{
		register_rest_route($this->namespace, '/' . $this->rest_base . '/order-status', array(
			array(
				'methods'             => WP_REST_Server::READABLE,
				'callback'            => array($this, 'get_order_status'),
				'permission_callback' => array($this, 'get_items_permissions_check'),
			),
		));
	}

	/**
	 * Get all get_order_status
	 *
	 * @since 2.2
	 *
	 * @param array $fields
	 * @param array $filter
	 * @param string $status
	 * @param int $page
	 *
	 * @return array
	 */
	public function get_order_status()
	{
		return  wc_get_order_statuses();
	}

	/**
	 * Check whether a given request has permission to read customers.
	 *
	 * @param  WP_REST_Request $request Full details about the request.
	 * @return WP_Error|boolean
	 */
	public function get_items_permissions_check($request)
	{
		if (!wc_rest_check_manager_permissions('settings', 'read')) {
			return new WP_Error('woocommerce_rest_cannot_view', __('Sorry, you cannot list resources.', 'woocommerce'), array('status' => rest_authorization_required_code()));
		}

		return true;
	}
}
