<?php
defined('ABSPATH') or exit;

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://www.zoorate.com
 * @since      1.0.0
 *
 * @package    Poinzilla
 * @subpackage Poinzilla/admin
 */

class Poinzilla_Admin
{
  private $plugin_name;
  private $version;

  public function __construct($plugin_name, $version)
  {
    $this->plugin_name = $plugin_name;
    $this->version = $version;
    add_action('admin_menu', array($this, 'poinzilla_admin_menu'));
  }

  public function enqueue_styles()
  {
    wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/poinzilla-admin.css', array(), $this->version, 'all');
  }

  public function enqueue_scripts()
  {
    wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/poinzilla-admin.js', array('jquery'), $this->version, false);
    wp_localize_script($this->plugin_name, "poinzilla_ajax", array("admin_ajax" => admin_url('admin-ajax.php')));
  }

  public function poinzilla_admin_menu()
  {
    add_menu_page(
      'Poinzilla Menu', // Page title
      'Poinzilla', // Menu title
      'manage_options', // Capability
      'poinzilla-menu', // Menu slug
      array($this, 'poinzilla_menu_callback'), // Function callback
      'data:image/svg+xml;base64,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'
    );

    add_submenu_page(
      'poinzilla-menu', // Parent slug
      'Esportazione', // Page title
      'Esportazione', // Menu title
      'manage_options', // Capability
      'poinzilla-export', // Menu slug
      array($this, 'poinzilla_export_users_page') // Function callback
    );
  }

  public function poinzilla_menu_callback()
  {
    include_once ('partials/poinzilla-admin-display.php');
  }

  public function poinzilla_export_users_page()
  {
    include_once ('partials/poinzilla-admin-export-users.php');
  }

  function poinzilla_woocommerce_notice()
  {
    include_once (ABSPATH . 'wp-admin/includes/plugin.php');
    if (!is_plugin_active('woocommerce/woocommerce.php')) {
      $class = 'notice notice-error';
      $message = __("Poinzilla Loyality requires WooCommerce plugin to be installed and activated", POINZILLA_TEXT_DOMAIN);
      printf('<div class="%1$s"><p>%2$s</p></div>', esc_attr($class), esc_html($message));
    }
  }
}
