(function ($) {
  "use strict";

  /**
   * All of the code for your admin-facing JavaScript source
   * should reside in this file.
   *
   * Note: It has been assumed you will write jQuery code here, so the
   * $ function reference has been prepared for usage within the scope
   * of this function.
   *
   * This enables you to define handlers, for when the DOM is ready:
   *
   * $(function() {
   *
   * });
   *
   * When the window is loaded:
   *
   * $( window ).load(function() {
   *
   * });
   *
   * ...and/or other possibilities.
   *
   * Ideally, it is not considered best practise to attach more than a
   * single DOM-ready or window-load handler for a particular page.
   * Although scripts in the WordPress core, Plugins and Themes may be
   * practising this, we should strive to set a better example in our own work.
   */
})(jQuery);


jQuery(document).on("click", "#poinzilla_push_order", function () {
  let button = jQuery(this); // Riferimento al bottone cliccato
  let order_id = button.attr("data_id");

  // Disabilita il bottone e cambia il testo
  button.prop("disabled", true).val("Attendere...");

  jQuery.ajax({
      url: poinzilla_ajax.admin_ajax,
      type: "post",
      data: {
          action: "poinzilla_push_external_order",
          order_id: order_id,
      },
      success: function (response) {
          console.log("Response Success: ", response); // Log per debug
          let container = jQuery(".poinzilla-order-sync-wrap .poinzilla-response");
          console.log("Container Found Length: ", container.length);

          if (container.length > 0) {
              if (response.success) {
                  container
                      .addClass("poinzilla-success")
                      .removeClass("poinzilla-error")
                      .html(response.data.message);
              } else {
                  container
                      .removeClass("poinzilla-success")
                      .addClass("poinzilla-error")
                      .html(response.data.message);
              }
          } else {
              console.error("Contenitore .poinzilla-response non trovato nel DOM.");
          }
      },
      error: function (xhr, status, error) {
          console.error("AJAX Error: ", status, error); // Log per debug
          jQuery(".poinzilaa-order-sync-wrap .poinzilla-response")
              .removeClass("poinzilla-success")
              .addClass("poinzilla-error")
              .html("Errore durante la richiesta AJAX.");
      },
      complete: function () {
          // Ripristina il bottone alla fine della chiamata
          button.prop("disabled", false).val("Sincronizza ora");
      },
  });
});
