<?php
defined('ABSPATH') or exit;

/**
 * Fired during plugin activation
 *
 * @link       https://www.zoorate.com
 * @since      1.0.0
 *
 * @package    Poinzilla
 * @subpackage Poinzilla/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Poinzilla
 * @subpackage Poinzilla/includes
 * @author     Zoorate srl <info@zoorate.com>
 */
class Poinzilla_Activator
{

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Poinzilla_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct()
	{
		$this->load_dependencies();
	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Poinzilla_Loader. Orchestrates the hooks of the plugin.
	 * - Poinzilla_i18n. Defines internationalization functionality.
	 * - Poinzilla_Admin. Defines all hooks for the admin area.
	 * - Poinzilla_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies()
	{

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-poinzilla-loader.php';


		$this->loader = new Poinzilla_Loader();
	}

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate()
	{
		include_once(ABSPATH . 'wp-admin/includes/plugin.php');
		if (!is_plugin_active('woocommerce/woocommerce.php')) {
			require_once(ABSPATH . 'wp-admin/includes/plugin.php');
			deactivate_plugins(plugin_basename(__FILE__));
			if (isset($_GET['activate'])) {
				unset($_GET['activate']);
			}
			wp_die('Could not be activated. Please install and activate woocommerce', POINZILLA_TEXT_DOMAIN);
		}


		do_action("poinzilla_activated");
	}
}
