<?php
defined('ABSPATH') or exit;

/**
 * Fired during plugin activation
 *
 * @link       https://www.zoorate.com
 * @since      1.0.0
 *
 * @package    Poinzilla
 * @subpackage Poinzilla/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Poinzilla
 * @subpackage Poinzilla/includes
 * @author     Zoorate srl <info@zoorate.com>
 */
class Poinzilla_PushOrder
{


  /**
   * Define the core functionality of the plugin.
   *
   * Set the plugin name and the plugin version that can be used throughout the plugin.
   * Load the dependencies, define the locale, and set the hooks for the admin area and
   * the public-facing side of the site.
   *
   * @since    1.0.0
   */
  public function __construct()
  {
  }

  public function poinzilla_register_meta_box()
  {
    add_meta_box('poinzilla-order-meta-box', esc_html__('Poinzilla - Invio manuale', 'poinzilla'), array($this, 'poinzilla_order_meta_box_callback'), 'shop_order', 'side', 'high');
    add_meta_box('poinzilla-order-meta-box', esc_html__('Poinzilla - Invio manuale', 'poinzilla'), array($this, 'poinzilla_order_meta_box_callback'), 'woocommerce_page_wc-orders', 'side', 'high');
  }
  //Add field
  public function poinzilla_order_meta_box_callback($meta_id)
  {
    ?>
    <div class="poinzilla-order-sync-wrap">
      <div style="margin-bottom:12px">
        <label for="poinzilla_push_order">Clicca qui per inviare l'ordine manualmente:</label>
      </div>
      <input id="poinzilla_push_order" class="button button-primary" type="button" value="Sincronizza ora"
        data_id="<?php echo $meta_id->ID; ?>" />
      <div class="poinzilla-response"></div>
    </div>
    <?php
  }
  public function poinzilla_push_external_order()
  {
    // Recupera l'ID dell'ordine dalla richiesta AJAX
    $resource_id = intval($_POST['order_id']);

    // Inizializza la classe di sincronizzazione
    $external_order = new Poinzilla_Sync_Order();

    // Prepara i dati da inviare
    $payloadData = $external_order->poinzilla_woo_order_sync_data_prepare($resource_id);

    // Effettua la chiamata API
    $response = $external_order->poinzilla_woo_order_sync_api($payloadData, get_option('poinzilla_enable_log'));

    // Definisce i messaggi di errore mappati
    $error_messages = array(
      400 => __('Dati inviati non validi. Verifica l\'ordine.', 'poinzilla'),
      401 => __('Non autorizzato. Controlla la chiave API.', 'poinzilla'),
      403 => __('Accesso negato. Verifica i permessi.', 'poinzilla'),
      404 => __('Risorsa non trovata. Controlla l\'ID dell\'ordine.', 'poinzilla'),
      500 => __('Errore interno del server Poinzilla. Riprova più tardi.', 'poinzilla'),
      503 => __('Servizio non disponibile. Riprova più tardi.', 'poinzilla'),
      'default' => __('Errore sconosciuto. Contatta il supporto.', 'poinzilla'),
    );

    // Gestisce la risposta
    if ($response['status'] == 200) {
      wp_send_json_success(array(
        'status' => 200,
        'message' => __('Ordine sincronizzato correttamente.', 'poinzilla'),
      ));
    } else {
      $status_code = $response['status'];
      $api_error_message = !empty($response['message']) ? $response['message'] : null;
      $error_message = isset($error_messages[$status_code]) ? $error_messages[$status_code] : $error_messages['default'];

      // Logga l'errore per il debug
      $logger = new Poinzilla_Logger();
      $logger->debug(
        'Errore API: ' . $status_code . ' - ' . $error_message . ($api_error_message ? ' (' . $api_error_message . ')' : ''),
        array('source' => 'poinzilla-order-sync')
      );

      // Invia il messaggio di errore al frontend
      wp_send_json_error(array(
        'status' => $status_code,
        'message' => $api_error_message ? $error_message . ' (' . $api_error_message . ')' : $error_message,
      ));
    }

    // Termina la richiesta
    wp_die();
  }
}