<?php
defined('ABSPATH') or die('Access denied!');

class Poinzilla_User_Export
{
  public function __construct()
  {
    add_action('admin_post_export_users', array($this, 'handle_export_users'));
  }

  public function handle_export_users()
  {
    if (!current_user_can('export')) {
      wp_die('You do not have sufficient permissions to access this page.');
    }

    $selected_roles = isset($_POST['user_roles']) ? $_POST['user_roles'] : [];
    $additional_points = isset($_POST['additional_points']) && is_numeric($_POST['additional_points']) ? (int)$_POST['additional_points'] : 0;


    ob_end_clean();
    nocache_headers();
    $filename = 'poinzilla_utenti_' . date('Y-m-d_H-i-s') . '.csv';
    header("Content-Type: text/csv");
    header("Content-Disposition: attachment; filename=\"$filename\"");

    $output = fopen("php://output", "w");
    fputcsv($output, array('firstName', 'lastName', 'email', 'externalId', 'points', 'groups', 'culture'), ';');

    $args = array(
      'role__in' => $selected_roles,
      'fields' => 'all_with_meta'
    );
    $users = get_users($args);
    foreach ($users as $user) {
      $firstName = $user->first_name ?: 'default';
      $lastName = $user->last_name ?: 'default';
      $points = $additional_points;  // Apply the optional points value here
      $language = get_option("WPLANG");
      if (!$language) {
        $language = 'en';
      }
      $locale = get_user_meta($user->ID, 'locale', true);
      if ($locale) {
        $language = explode('_', $locale)[0];
      }
      $wpml_user_languge = get_user_meta($user->ID, 'icl_admin_language', true);
      if ($wpml_user_languge) {
        $language = $wpml_user_languge;
      }

      $trp_language = get_user_meta($user->ID, 'trp_language', true);
      if ($trp_language) {
        $language = explode('_', $trp_language)[0];
      }

      $language = explode('_', $language)[0];
      fputcsv($output, array($firstName, $lastName, $user->user_email, $user->ID, $points, implode(',', $user->roles), $language), ';');
    }
    fclose($output);
    exit;
  }
}
