<?php

/**
 * Plugin Name:       Poinzilla
 * Plugin URI:        https://poinzilla.com
 * Description:       Plugin WordPress per Poinzilla
 * Version:           1.2.2
 * Author:            Feedaty srl
 * Author URI:        https://www.feedaty.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       poinzilla
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
	die;
}

/**
 * Currently plugin version.
 */
define('POINZILLA_VERSION', '1.2.2');

/**
 * Currently plugin Text Domain.
 */
define('POINZILLA_TEXT_DOMAIN', "poinzilla");
/**
 * api url for version v1 api.
 */
define('POINZILLA_API_URL_V1', "https://api.poinzilla.com");

/**
 * widget url for version v1 api.
 */
define('POINZILLA_WIDGET_URL_V1', "https://widget.poinzilla.com");


/**
 * SDK url for version v1 api.
 */
define('POINZILLA_SDK_URL_V1', "https://sdk.poinzilla.com/sdk.umd.js");

/**
 * Currently plugin base path.
 */
define('POINZILLA_PLUGIN_URL', plugin_dir_url(__FILE__));



/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-poinzilla-activator.php
 */
function activate_poinzilla()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-poinzilla-activator.php';
	require_once plugin_dir_path(__FILE__) . 'includes/class-poinzilla-logger.php';
	require_once plugin_dir_path(__FILE__) . 'includes/class-poinzilla-installer.php';
	$logger = new Poinzilla_Logger();
	$installer = new Poinzilla_Installer();
	$context = array('source' => 'Poinzilla-Plugin-Activate');
	$logger->debug('plugin activated', $context);
	Poinzilla_Activator::activate();
	$installer->init();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-poinzilla-deactivator.php
 */
function deactivate_poinzilla()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-poinzilla-deactivator.php';
	require_once plugin_dir_path(__FILE__) . 'includes/class-poinzilla-logger.php';
	$logger = new Poinzilla_Logger();
	$context = array('source' => 'Poinzilla-Plugin-Deactivate');
	$logger->debug('plugin deactivated', $context);
	Poinzilla_Deactivator::deactivate();
}

function update_poinzilla()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-poinzilla-updater.php';
	Poinzilla_Updater::update();
}

register_activation_hook(__FILE__, 'activate_poinzilla');
register_deactivation_hook(__FILE__, 'deactivate_poinzilla');;

add_action('upgrader_process_complete', 'update_poinzilla');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-poinzilla.php';



/**
 * Check WooCommerce Dependencies
 *
 * @since     1.0.0
 * @return    string    Deactivate Plugin if woocommerce is not activate
 */
function check_woocommerce_dependencies()
{
}

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_poinzilla()
{

	$plugin = new Poinzilla();
	$plugin->run();
}
run_poinzilla();
