<?php
defined('ABSPATH') OR exit;

/**
 * API per esporre i gruppi di consumatori (ruoli) di WordPress
 *
 * @package    Poinzilla
 * @subpackage Poinzilla/includes
 */
class Poinzilla_Consumer_Group {

    /**
     * Inizializza la classe e imposta gli hook
     */
    public function __construct() {
  
    }

    /**
     * Registra l'endpoint REST per i ruoli
     */
    public function register_roles_endpoint() {
        register_rest_route('poinzilla/v1', '/roles', array(
            'methods'             => WP_REST_Server::READABLE,
            'callback'            => array($this, 'get_roles'),
            'permission_callback' => array($this, 'check_permissions')
        ));
    }

    /**
     * Verifica i permessi per l'accesso all'API
     */
    public function check_permissions() {
      
        return true;
    }

    /**
     * Restituisce tutti i ruoli WordPress
     */
    public function get_roles() {
        global $wp_roles;
        
        if (!isset($wp_roles)) {
            $wp_roles = new WP_Roles();
        }
        
        $all_roles = $wp_roles->roles;
        $roles_data = array();
        
        foreach ($all_roles as $role_key => $role) {
            $roles_data[] = array(
                'id' => $role_key,
                'name' => translate_user_role($role['name'])
            );
        }
        
        return rest_ensure_response($roles_data);
    }
}
