<?php
defined('ABSPATH') or exit;

/**
 * Fired during plugin activation
 *
 * @link       https://www.zoorate.com
 * @since      1.0.0
 *
 * @package    Poinzilla
 * @subpackage Poinzilla/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Poinzilla
 * @subpackage Poinzilla/includes
 * @author     Zoorate srl <info@zoorate.com>
 */
class Poinzilla_Installer
{


	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct()
	{
	}

	public function init()
	{
		$this->create_antry_for_version();
    $this->activate();
		$this->poinzilla_notify_server_to_plugin_active();
	}
  public function activate() {
    if (get_option('poinzilla_setup_mode') === null) {
      add_option('poinzilla_setup_mode', 1);
    }
  }

	public function create_antry_for_version()
	{
		update_option("poinzilla_current_version", POINZILLA_VERSION);
	}

	public function poinzilla_notify_server_to_plugin_active()
	{
		$poinzilla_api_response = wp_remote_post(
			POINZILLA_API_URL_V1 . "poinzilla/notification/plugin-active",
			array(
				'method'    => 'POST',
				"body"      => json_encode(array(
					"site_url" => site_url(),
					"site_ip_address" => $_SERVER['SERVER_ADDR']
				)),
				'headers'   => array(
					'content-type' => 'application/json',
				),
			)
		);
	}
}
