<?php
defined('ABSPATH') or exit;

/**
 * Fired during plugin activation
 *
 * @link       https://www.zoorate.com
 * @since      1.0.0
 *
 * @package    Poinzilla
 * @subpackage Poinzilla/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Poinzilla
 * @subpackage Poinzilla/includes
 * @author     Zoorate srl <info@zoorate.com>
 */
class Poinzilla_Rewrite_Rule
{


	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct()
	{
	}


	/**
	 * add_new_webhook_topics adds the new webhook to the dropdown list on the Webhook page.
	 * @param array $topics Array of topics with the i18n proper name.
	 */
	public function poinzilla_add_rewrite_rule()
	{
		add_rewrite_rule('referral/([^/]+)/referral', 'index.php?referral=$matches[1]', 'top');
	}


	/**
	 * add_new_webhook_topics adds the new webhook to the dropdown list on the Webhook page.
	 * @param array $topics Array of topics with the i18n proper name.
	 */
	public function poinzilla_add_query_vars($query_vars)
	{
		$query_vars[] = 'referral';
		return $query_vars;
	}


	/**
	 * add_new_webhook_topics adds the new webhook to the dropdown list on the Webhook page.
	 * @param array $topics Array of topics with the i18n proper name.
	 */
	public function poinzilla_template_include($template)
	{

		if (get_query_var('referral') == false || get_query_var('referral') == '') {
			return $template;
		}

		$poinzilla_api_response = wp_remote_post(
			POINZILLA_API_URL_V1 . "/api/Widget/Init",
			array(
				'method'    => 'GET',
				'headers'     => array(
					'X-loyalty-channel-key' => get_option('poinzilla_api_key'), //poinzilla_api_secret
					'Content-type' => 'application/json'
				),
			)
		);
		$response_data = json_decode(wp_remote_retrieve_body($poinzilla_api_response),1);
		
		$og_title = $response_data['referralsProgram']['referralShare']['title'];
		$og_description = $response_data['referralsProgram']['referralShare']['description'];
		$og_image = $response_data['referralsProgram']['referralShare']['imageUrl'];
		$logourl = $response_data['merchantChannel']['companyLogoUrl'];
	
?>
		<html>

		<head>

			<meta property='og:title' content='<?php echo $og_title; ?>' />
			<meta property='og:description' content='<?php echo $og_description; ?>' />
			<meta property='og:image' content='<?php echo $og_image; ?>' />
			<meta property="og:locale" content="<?php echo get_locale(); ?>" />
            <meta property="og:url" content="<?php echo site_url(); ?>" />
            <meta property="og:type" content="website" />
            <meta property="og:logo" content="<?php echo $logourl; ?>" />
		</head>
		<script>
			window.location.href = "<?php echo get_site_url() . "?referral_code=" . get_query_var('referral') . "&default_view=referral-action" ?>"
		</script>

		<body></body>

		</html>
<?php

		exit;
	}
}
