<?php
defined('ABSPATH') or exit;
/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://www.zoorate.com
 * @since      1.0.0
 *
 * @package    Poinzilla
 * @subpackage Poinzilla/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Poinzilla
 * @subpackage Poinzilla/public
 * @author     Zoorate srl <info@zoorate.com>
 */
class Poinzilla_Public
{

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct($plugin_name, $version)
	{

		$this->plugin_name = $plugin_name;
		$this->version = $version;
	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function poinzilla_enqueue_styles()
	{

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Poinzilla_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Poinzilla_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		//wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/poinzilla-public.css', array(), $this->version, 'all');
	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function poinzilla_enqueue_scripts()
	{

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Poinzilla_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Poinzilla_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		//wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/poinzilla-public.js', array('jquery'), $this->version, false);
	}

	public function poinzilla_footer_hook()
	{

		global $poizilla_is_setup_mode;
		if (!$poizilla_is_setup_mode || ($poizilla_is_setup_mode && \is_user_logged_in() && \current_user_can('administrator'))) {
			include_once('partials/poinzilla-public-display.php');
		}
	}

	public function poinzilla_user_register($user_id, $userdata = array(), $userdata_update = array())
	{

		$user_data = get_user_by('id', $user_id);
		$user_metas = get_user_meta($user_id);
		$language = get_option("WPLANG");
		if (!$language) {
			$language = 'en';
		}
		$locale = get_user_meta($user_id, 'locale', true);
		if ($locale) {
			$language = explode('_', $locale)[0];
		}
		$wpml_user_languge = get_user_meta($user_id, 'icl_admin_language', true);
		if ($wpml_user_languge) {
			$language = $wpml_user_languge;
		}

		$trp_language = get_user_meta($user_id, 'trp_language', true);
		if ($trp_language) {
			$language = explode('_', $trp_language)[0];
		}


		$user_array = array(
			"email" => $user_data->data->user_email,
			"firstName" => $user_metas['first_name'][0] ? $user_metas['first_name'][0] : "default",
			"lastName" => $user_metas['last_name'][0] ? $user_metas['last_name'][0] : "default",
			"password" => 'dummyD@123',
			"merchantCode" => get_option('poinzilla_merchant_code'),
			"externalId" => (string)$user_id,
			"cultureId" => $language,
			"group" => $user_data->roles

			// "birthDate" => array(
			// 	"year" => 1994,
			// 	"month" => 11,
			// 	"day" => 27,
			// 	"dayOfWeek" => 0,
			// )
		);
		$response = wp_remote_post(
			POINZILLA_API_URL_V1 . '/api/External/Consumer',
			array(
				'method'      => 'POST',
				'timeout'     => 45,
				'redirection' => 5,
				'httpversion' => '1.0',
				'blocking'    => true,
				'headers'     => array(
					'X-loyalty-channel-key' => get_option('poinzilla_api_key'), //poinzilla_api_secret
					'Content-type' => 'application/json'
				),
				'body'        => json_encode($user_array),
				'cookies'     => array()
			)
		);
		// print_r(array(
		// 	'method'      => 'POST',
		// 	'timeout'     => 45,
		// 	'redirection' => 5,
		// 	'httpversion' => '1.0',
		// 	'blocking'    => true,
		// 	'headers'     => array(
		// 		'X-loyalty-channel-key' => get_option('poinzilla_api_key'),
		// 		'Content-type' => 'application/json'
		// 	),
		// 	'body'        => json_encode($user_array),
		// 	'cookies'     => array()
		// ));
		// print_r($user_array);
		// print_r($response);
		// print_r($user_metas);
		// print_r($user_metas);
		if ($response['response']['code'] == 200) {
			update_user_meta($user_id, 'is_sync_with_poinzilla', true);
		}
		if ($response['response']['code'] == 400) {
			$response_data = wp_remote_retrieve_body($response);
			update_user_meta($user_id, 'is_sync_with_poinzilla', true);
			// if
		}

		// exit;
	}

	public function poinzilla_generate_digest($user_email)
	{

		return hash_hmac(
			'sha256',
			get_option('poinzilla_merchant_code') . $user_email,
			get_option('poinzilla_api_secret')
		);
	}
}
